package com.elitescloud.boot.datasecurity.jpa.strategy.stringStrategy;

import com.elitescloud.boot.datasecurity.jpa.strategy.RuleStrategy;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringPath;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-25 18:35
 */
public class StringContainStrategy implements RuleStrategy {

    @Override
    public Predicate applyRule(PathBuilder<?> entityPath, String fieldName, String ruleValue) {
        StringPath path = entityPath.getString(fieldName);
        return path.contains(ruleValue);
    }
}