package com.elitescloud.boot.datasecurity.support;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitescloud.boot.datasecurity.common.extension.FieldPermissionExtension;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.annotation.SysCodeName;
import org.springframework.util.StringUtils;

import java.lang.reflect.Field;
import java.util.*;

/**
 * 相关UDC字段获取.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/18
 */
public class UdcFieldPermissionCleaner implements FieldPermissionExtension {

    private final Map<Class<?>, Set<String>> cache = new HashMap<>(128);

    @Override
    public Set<String> getUnreadableFields(Object bean, Set<String> unreadableFields) {
        return cache.computeIfAbsent(bean.getClass(), c -> obtainUdcFields(c, unreadableFields));
    }

    private Set<String> obtainUdcFields(Class<?> clazz, Set<String> eraseFieldNames) {
        var fields = ReflectUtil.getFields(clazz);
        if (ArrayUtil.isEmpty(fields)) {
            return Collections.emptySet();
        }

        Set<String> result = new HashSet<>(fields.length);
        SysCode sysCode = null;
        SysCodeName sysCodeName = null;
        String tempFieldName = null;
        for (Field field : fields) {
            // 是否为UDC字段
            sysCode = field.getAnnotation(SysCode.class);
            if (sysCode != null) {
                tempFieldName = CharSequenceUtil.blankToDefault(sysCode.nameField(), field.getName() + "Name");
                if (eraseFieldNames.contains(field.getName())) {
                    result.add(tempFieldName);
                }

                continue;
            }

            // UDC的name字段
            sysCodeName = field.getAnnotation(SysCodeName.class);
            if (sysCodeName != null) {
                tempFieldName = this.obtainUdcFieldName(sysCodeName, field.getName());
                if (eraseFieldNames.contains(tempFieldName)) {
                    result.add(field.getName());
                }
            }

        }
        return result;
    }

    private String obtainUdcFieldName(SysCodeName sysCodeName, String fieldName) {
        if (StringUtils.hasText(sysCodeName.udcField())) {
            return sysCodeName.udcField();
        }

        if (fieldName.endsWith("Name")) {
            return fieldName.substring(0, fieldName.length() - 4);
        }

        return "";
    }
}
