/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.dpr.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.auth.util.SecurityUtil;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.constant.CompatibleModeEnum;
import com.elitescloud.boot.datasecurity.config.DataSecurityProperties;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleCacheService;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.constant.DataPermissionType;
import com.elitescloud.cloudt.system.dto.BaseDataSecurityRuleDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RoleDataPermissionRuleServiceImpl
implements RoleDataPermissionRuleService {
    private static final Logger log = LoggerFactory.getLogger(RoleDataPermissionRuleServiceImpl.class);
    private final RoleDataPermissionRuleCacheService roleDataPermissionRuleCacheInterface;
    private final DataSecurityProperties properties;

    public RoleDataPermissionRuleServiceImpl(RoleDataPermissionRuleCacheService roleDataPermissionRuleCacheInterface, DataSecurityProperties properties) {
        this.roleDataPermissionRuleCacheInterface = roleDataPermissionRuleCacheInterface;
        this.properties = properties;
    }

    @Override
    public SysDprRoleApiRowColumnRuleDTO getMatchedDataPermission() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return null;
        }
        SysDprRoleApiRowColumnRuleDTO dataPermission = this.queryDataPermission(request);
        String businessObjectCode = this.obtainBusinessObjectCode(request);
        String businessOperationCode = this.obtainBusinessOperationCode(request);
        if (StringUtils.hasText((String)businessOperationCode) && CharSequenceUtil.isBlank((CharSequence)businessObjectCode)) {
            businessObjectCode = this.queryBusinessObjectCodeByBusinessOperationCode(businessOperationCode);
        }
        return this.matchDataPermission(dataPermission, businessObjectCode, businessOperationCode);
    }

    @Override
    public SysDprRoleApiRowColumnRuleDTO getOriginalDataPermission() {
        return this.queryDataPermission(HttpServletUtil.currentRequest());
    }

    @Override
    public SysDprRoleApiRowColumnRuleDTO matchDataPermission(SysDprRoleApiRowColumnRuleDTO ruleDTO, String businessObjectCode, String businessOperationCode) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (ruleDTO == null || request == null) {
            return null;
        }
        if (CollUtil.isEmpty((Collection)ruleDTO.getSysDprRoleApiDataRuleListQueryDTO()) && CollUtil.isEmpty((Collection)ruleDTO.getSysDpcRoleApiFieldsDTOList())) {
            return ruleDTO;
        }
        if (StringUtils.hasText((String)businessObjectCode)) {
            businessObjectCode = businessObjectCode.contains(":") ? businessObjectCode.split(":")[0] : businessObjectCode;
        } else if (StringUtils.hasText((String)businessOperationCode)) {
            businessObjectCode = this.queryBusinessObjectCodeByBusinessOperationCode(businessOperationCode);
        }
        log.info("start to match row rule...");
        ruleDTO.setSysDprRoleApiDataRuleListQueryDTO(this.filterRule(request, businessObjectCode, businessOperationCode, ruleDTO.getSysDprRoleApiDataRuleListQueryDTO()));
        log.info("start to match field rule...");
        ruleDTO.setSysDpcRoleApiFieldsDTOList(Boolean.FALSE.equals(this.properties.getFieldPermission().getEnabled()) ? Collections.emptyList() : this.filterRule(request, businessObjectCode, businessOperationCode, ruleDTO.getSysDpcRoleApiFieldsDTOList()));
        return ruleDTO;
    }

    private SysDprRoleApiRowColumnRuleDTO queryDataPermission(HttpServletRequest request) {
        if (!this.supportDataPermission(request)) {
            log.info("do not support data permission");
            return null;
        }
        String token = SecurityContextUtil.currentToken();
        if (!StringUtils.hasText((String)token)) {
            log.error("\u6570\u636e\u6743\u9650\uff1a\u83b7\u53d6Token\u4e3a\u7a7a ");
            SecurityUtil.throwUnauthorizedException();
            return null;
        }
        SysDprRoleApiRowColumnRuleDTO rule = this.roleDataPermissionRuleCacheInterface.getTokenDprLocalCache(token).orElseGet(() -> this.roleDataPermissionRuleCacheInterface.getTokenDprRedisCache(token).orElseGet(() -> this.roleDataPermissionRuleCacheInterface.roleDataPermissionRuleRpc(token)));
        if (rule == null) {
            return null;
        }
        SysDprRoleApiRowColumnRuleDTO filteredRule = new SysDprRoleApiRowColumnRuleDTO();
        filteredRule.setUserId(rule.getUserId());
        filteredRule.setTenantId(rule.getTenantId());
        filteredRule.setTenantOrgId(rule.getTenantOrgId());
        filteredRule.setRoelIdList(rule.getRoelIdList());
        filteredRule.setRoleCodeList(rule.getRoleCodeList());
        filteredRule.setSysDprRoleApiDataRuleListQueryDTO(rule.getSysDprRoleApiDataRuleListQueryDTO());
        filteredRule.setSysDpcRoleApiFieldsDTOList(Boolean.FALSE.equals(this.properties.getFieldPermission().getEnabled()) ? Collections.emptyList() : rule.getSysDpcRoleApiFieldsDTOList());
        return filteredRule;
    }

    private boolean supportDataPermission(HttpServletRequest request) {
        if (request == null) {
            log.info("not a web request");
            return false;
        }
        if (Boolean.FALSE.equals(this.properties.getEnabled())) {
            return false;
        }
        String uri = request.getRequestURI();
        return !uri.startsWith("/rpc");
    }

    private <T extends BaseDataSecurityRuleDTO> List<T> filterRule(HttpServletRequest request, String businessObjectCode, String businessOperationCode, List<T> ruleList) {
        log.info("businessObject:{}, businessObjectOperation:{}", (Object)businessObjectCode, (Object)businessOperationCode);
        List<T> filteredRuleList = this.filterByMenuOperation(ruleList, request, businessObjectCode, businessOperationCode);
        if (!filteredRuleList.isEmpty()) {
            log.info("matched by MenuOperation");
            return filteredRuleList;
        }
        if (this.properties.getCompatible() == CompatibleModeEnum.OLDEST) {
            return Collections.emptyList();
        }
        if (CharSequenceUtil.isBlank((CharSequence)businessObjectCode)) {
            return Collections.emptyList();
        }
        filteredRuleList = this.filterByBusinessOperation(ruleList, request, businessObjectCode, businessOperationCode);
        if (!filteredRuleList.isEmpty()) {
            log.info("matched by BusinessOperation");
            return filteredRuleList;
        }
        filteredRuleList = this.filterByBusinessObject(ruleList, businessObjectCode);
        if (!filteredRuleList.isEmpty()) {
            log.info("matched by BusinessObject");
            return filteredRuleList;
        }
        log.info("No permission rules were matched\uff1a{}", (Object)request.getRequestURI());
        return filteredRuleList;
    }

    private <T extends BaseDataSecurityRuleDTO> List<T> filterByMenuOperation(List<T> ruleList, HttpServletRequest request, String businessObjectCode, String businessOperationCode) {
        String menuCode = request.getHeader("menuCode");
        log.info("menuCode\uff1a{}", (Object)menuCode);
        if (CharSequenceUtil.isBlank((CharSequence)menuCode)) {
            return Collections.emptyList();
        }
        CompatibleModeEnum compatible = this.properties.getCompatible();
        return ruleList.stream().filter(t -> {
            if (compatible == CompatibleModeEnum.OLDEST ? StringUtils.hasText((String)t.getPermissionType()) : compatible == CompatibleModeEnum.LATEST && !StringUtils.hasText((String)t.getPermissionType())) {
                return false;
            }
            if (!menuCode.equals(t.getMenusCode())) {
                return false;
            }
            if (StringUtils.hasText((String)t.getPermissionType())) {
                if (!DataPermissionType.MENU_OPERATION_RULE.name().equals(t.getPermissionType())) {
                    return false;
                }
                if (!t.getBusinessObjectCode().equals(businessObjectCode)) {
                    return false;
                }
                if (CharSequenceUtil.isBlank((CharSequence)businessOperationCode)) {
                    return false;
                }
            }
            return this.isMatchRequestForOperation(t, request, businessOperationCode);
        }).collect(Collectors.toList());
    }

    private <T extends BaseDataSecurityRuleDTO> List<T> filterByBusinessOperation(List<T> ruleList, HttpServletRequest request, String businessObjectCode, String businessOperationCode) {
        if (!StringUtils.hasText((String)businessObjectCode)) {
            return Collections.emptyList();
        }
        return ruleList.stream().filter(t -> {
            if (!DataPermissionType.BUSINESS_OPERATION_RULE.name().equals(t.getPermissionType())) {
                return false;
            }
            if (!businessObjectCode.equals(t.getBusinessObjectCode())) {
                return false;
            }
            return this.isMatchRequestForOperation(t, request, businessOperationCode);
        }).collect(Collectors.toList());
    }

    private <T extends BaseDataSecurityRuleDTO> List<T> filterByBusinessObject(List<T> ruleList, String businessObjectCode) {
        if (!StringUtils.hasText((String)businessObjectCode)) {
            return Collections.emptyList();
        }
        return ruleList.stream().filter(t -> {
            if (!DataPermissionType.BUSINESS_OBJECT_RULE.name().equals(t.getPermissionType())) {
                return false;
            }
            return businessObjectCode.equals(t.getBusinessObjectCode());
        }).collect(Collectors.toList());
    }

    private String queryBusinessObjectCodeByBusinessOperationCode(String businessOperationCode) {
        SysBusinessOperationDTO businessOperation = this.roleDataPermissionRuleCacheInterface.getBusinessOperationByBusinessOperationCode(businessOperationCode);
        Assert.notNull((Object)businessOperation, (String)("\u4e1a\u52a1\u64cd\u4f5c[" + businessOperationCode + "]\u4e0d\u5b58\u5728"));
        return businessOperation.getBusinessObjectCode();
    }

    private String obtainBusinessObjectCode(HttpServletRequest request) {
        String businessObjectCode = request.getHeader("X-Cloudt-BusinessObject");
        if (StringUtils.hasText((String)businessObjectCode)) {
            return businessObjectCode;
        }
        BusinessObject businessObject = (BusinessObject)request.getAttribute("cloudt-businessObject");
        BusinessObjectOperation businessOperation = (BusinessObjectOperation)request.getAttribute("cloudt-businessObject-operation");
        if (businessOperation == null && businessObject == null) {
            return null;
        }
        if (businessOperation != null) {
            if ("@BusinessObject".equals(businessOperation.businessObjectType())) {
                return businessObject == null ? null : businessObject.businessType().split(":")[0];
            }
            return businessOperation.businessObjectType().split(":")[0];
        }
        return businessObject.businessType().split(":")[0];
    }

    private String obtainBusinessOperationCode(HttpServletRequest request) {
        String businessOperationCode = request.getHeader("X-Cloudt-BusinessOperation");
        if (StringUtils.hasText((String)businessOperationCode)) {
            return businessOperationCode;
        }
        BusinessObjectOperation businessOperation = (BusinessObjectOperation)request.getAttribute("cloudt-businessObject-operation");
        if (businessOperation == null) {
            return null;
        }
        return StringUtils.hasText((String)businessOperation.operationCode()) ? businessOperation.operationCode() : null;
    }

    private <T extends BaseDataSecurityRuleDTO> boolean isMatchRequestForOperation(@NotNull T rule, @NotNull HttpServletRequest request, String operationCode) {
        String apiCode = request.getHeader("apiCode");
        if (StringUtils.hasText((String)apiCode)) {
            return apiCode.equals(rule.getApiPermissionCode());
        }
        if (rule.getApiPermissionCode().equals(operationCode)) {
            return true;
        }
        if (!request.getMethod().equalsIgnoreCase(rule.getApiPermissionRequestType())) {
            return false;
        }
        String uri = request.getRequestURI();
        Map pathVariables = HttpServletUtil.getPathVariables((HttpServletRequest)request);
        if (pathVariables.isEmpty()) {
            return uri.equals(rule.getApiPermissionPath());
        }
        String path = StringUtils.hasText((String)rule.getPermissionType()) ? StrUtil.format((CharSequence)rule.getApiPermissionPath(), (Map)pathVariables) : MessageFormat.format(rule.getApiPermissionPath(), pathVariables.values());
        return uri.equals(path);
    }
}

