package com.elitescloud.boot.datasecurity.common.extension;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Set;

/**
 * 字段权限扩展器.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/18
 */
@FunctionalInterface
public interface FieldPermissionExtension {

    /**
     * 获取不可读字段
     *
     * @param bean            数据对象
     * @param unreadableFields 字段名称
     */
    Set<String> getUnreadableFields(@NotNull Object bean, @NotEmpty Set<String> unreadableFields);
}
