package com.elitescloud.boot.datasecurity.config;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.MapSearcher;
import com.elitescloud.boot.datasecurity.common.extension.FieldPermissionExtension;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherPermissionRuleServiceImpl;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleCacheService;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.service.impl.RoleDataPermissionRuleCacheServiceImpl;
import com.elitescloud.boot.datasecurity.dpr.service.impl.RoleDataPermissionRuleServiceImpl;
import com.elitescloud.boot.datasecurity.jpa.strategy.RoleRuleJpaService;
import com.elitescloud.boot.datasecurity.support.DataSecurityUdcFilter;
import com.elitescloud.boot.datasecurity.support.FieldPermissionInterceptor;
import com.elitescloud.boot.datasecurity.support.UdcFieldPermissionCleaner;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.system.provider.extend.SysBusinessObjectRpcService;
import com.elitescloud.cloudt.system.service.RoleAppApiDataPermissionRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;

/**
 * 数据安全自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/17/2023
 */
@Import({
        CloudtDataSecurityAutoConfiguration.BeanSearchConfig.class, CloudtDataSecurityAutoConfiguration.JpaConfig.class
})
@EnableConfigurationProperties({DataSecurityProperties.class})
@Slf4j
class CloudtDataSecurityAutoConfiguration {

    private final DataSecurityProperties properties;

    public CloudtDataSecurityAutoConfiguration(DataSecurityProperties properties) {
        this.properties = properties;
    }

    @Bean
    public RoleDataPermissionRuleService roleDataPermissionRuleService(RedisUtils redisUtils,
                                                                       RoleAppApiDataPermissionRpcService roleAppApiDataPermissionRpcService,
                                                                       SysBusinessObjectRpcService businessObjectRpcService,
                                                                       TaskExecutor taskExecutor) {
        RoleDataPermissionRuleCacheService dataPermissionRuleCacheInterface = new RoleDataPermissionRuleCacheServiceImpl(redisUtils,
                roleAppApiDataPermissionRpcService, businessObjectRpcService, taskExecutor);
        return new RoleDataPermissionRuleServiceImpl(dataPermissionRuleCacheInterface, properties);
    }

    @Bean
    public DataSecurityUdcFilter dataSecurityUdcFilter() {
        return new DataSecurityUdcFilter(properties);
    }

    @Bean
    public FieldPermissionInterceptor fieldPermissionInterceptor() {
        return new FieldPermissionInterceptor();
    }

    @Bean
    public FieldPermissionExtension udcFieldPermissionCleaner() {
        return new UdcFieldPermissionCleaner();
    }

    @ConditionalOnClass(BeanSearcher.class)
    class BeanSearchConfig {

        @Bean
        public BeanSearcherPermissionRuleService beanSearcherPermissionRuleService(TenantClientProvider tenantClientProvider) {
            return new BeanSearcherPermissionRuleServiceImpl(tenantClientProvider);
        }

        @Bean
        public BeanSearcherFactory beanSearcherFactory(BeanSearcher beanSearcher,
                                                       MapSearcher mapSearcher,
                                                       TenantClientProvider tenantClientProvider,
                                                       BeanSearcherPermissionRuleService beanSearcherPermissionRuleService) {
            return new BeanSearcherFactory(beanSearcher, mapSearcher, tenantClientProvider, beanSearcherPermissionRuleService);
        }
    }

    class JpaConfig {
        @Bean
        public RoleRuleJpaService roleRuleJpaService() {
            return new RoleRuleJpaService();
        }
    }
}
