package com.elitescloud.boot.datasecurity.config;

import com.elitescloud.boot.common.constant.CompatibleModeEnum;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.util.Set;

/**
 * 数据权限属性配置.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/28
 */
@ConfigurationProperties(prefix = DataSecurityProperties.CONFIG_PREFIX)
public class DataSecurityProperties {
    public static final String CONFIG_PREFIX = "elitesland.data-security";

    /**
     * 是否启用
     */
    private Boolean enabled = true;

    /**
     * 兼容模式
     */
    private CompatibleModeEnum compatible = CompatibleModeEnum.LATEST;

    /**
     * 权限冲突时是否展示
     * <p>
     * 当用户的多个角色对同一个资源配置出现冲突时，是否拥有的优先级更高，如一个角色配置用户无权限查看字段A，另一个角色配置用户有权限查看字段A，最终是否有权限查看
     */
    private Boolean conflictShow = false;

    /**
     * 应用于数据权限的基础字段
     */
    private Set<String> baseFields = Set.of("belongOrgId", "createUserId");

    /**
     * 基础字段中表示组织ID的字段
     */
    private Set<String> orgIdBaseFields = Set.of("belongOrgId", "tenantOrgId", "secBuId", "secOuId");

    /**
     * 基础字段中表示用户ID的字段
     */
    private Set<String> userIdBaseFields = Set.of("createUserId", "modifyUserId", "secUserId");

    /**
     * 字段权限
     */
    @NestedConfigurationProperty
    private FieldPermissionProperties fieldPermission = new FieldPermissionProperties();

    /**
     * UDC权限配置
     */
    @NestedConfigurationProperty
    private UdcProperties udc = new UdcProperties();

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public CompatibleModeEnum getCompatible() {
        return compatible;
    }

    public void setCompatible(CompatibleModeEnum compatible) {
        this.compatible = compatible;
    }

    public Boolean getConflictShow() {
        return conflictShow;
    }

    public void setConflictShow(Boolean conflictShow) {
        this.conflictShow = conflictShow;
    }

    public Set<String> getBaseFields() {
        return baseFields;
    }

    public void setBaseFields(Set<String> baseFields) {
        this.baseFields = baseFields;
    }

    public Set<String> getOrgIdBaseFields() {
        return orgIdBaseFields;
    }

    public void setOrgIdBaseFields(Set<String> orgIdBaseFields) {
        this.orgIdBaseFields = orgIdBaseFields;
    }

    public Set<String> getUserIdBaseFields() {
        return userIdBaseFields;
    }

    public void setUserIdBaseFields(Set<String> userIdBaseFields) {
        this.userIdBaseFields = userIdBaseFields;
    }

    public FieldPermissionProperties getFieldPermission() {
        return fieldPermission;
    }

    public void setFieldPermission(FieldPermissionProperties fieldPermission) {
        this.fieldPermission = fieldPermission;
    }

    public UdcProperties getUdc() {
        return udc;
    }

    public void setUdc(UdcProperties udc) {
        this.udc = udc;
    }

    public static class UdcProperties {

        /**
         * 是否启用
         */
        private Boolean enabled = false;

        public Boolean getEnabled() {
            return enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class FieldPermissionProperties {
        /**
         * 是否启用字段权限
         */
        private Boolean enabled = true;

        /**
         * 应用于字段权限的基础字段
         */
        private Set<String> baseFields = Set.of("belongOrgId", "createUserId");

        /**
         * 无权限的内容显示
         */
        private String placeholder = "*";

        public Boolean getEnabled() {
            return enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Set<String> getBaseFields() {
            return baseFields;
        }

        public void setBaseFields(Set<String> baseFields) {
            this.baseFields = baseFields;
        }

        public String getPlaceholder() {
            return placeholder;
        }

        public void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
        }
    }
}
