package com.elitescloud.boot.datasecurity.dpr.service;

import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;

/**
 * @author : chen
 * 数据权限规则解析接口
 * 需要bean Seacher和jpa分别实现。
 * @date 2022-11-24 14:12
 */
public interface RoleDataPermissionRuleService {

    /**
     * 获取匹配过的数据权限
     *
     * @return 数据权限规则
     */
    SysDprRoleApiRowColumnRuleDTO getMatchedDataPermission();

    /**
     * 获取原始数据权限
     *
     * @return 数据权限规则
     */
    SysDprRoleApiRowColumnRuleDTO getOriginalDataPermission();

    /**
     * 过滤权限
     *
     * @param ruleDTO               权限规则
     * @param businessObjectCode    业务对象编码
     * @param businessOperationCode 业务对象操作编码
     * @return 权限规则
     */
    SysDprRoleApiRowColumnRuleDTO matchDataPermission(SysDprRoleApiRowColumnRuleDTO ruleDTO, String businessObjectCode,
                                                      String businessOperationCode);
}