package com.elitescloud.boot.datasecurity.dpr.service.util;

import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.Collections;

/**
 * @author : chen
 * 工具类
 * @date 2022-11-30 15:01
 */
public class DataPermissionRuleServiceUtil {


    /**
     * @param @param null
     * @return
     * @description 异常处理。
     */
    public static void throwRuntimeException(String msg, SysDprRoleApiDataRuleListQueryDTO rule) {
        Gson gson = new Gson();
        var data = gson.toJson(rule);
        throw new RuntimeException("数据权限异常：" + msg + data);

    }

    /****根据规则条件类型枚举，采用bs构造器构造查询条件和参数****/
    public static void dprRuleValueTypeMapBuilder(MapBuilder mapBuilder, SysDprRoleApiDataRuleListQueryDTO rule) {
        String valueType = rule.getDprRuleValueType();
        String value = rule.getDprRuleValue();
        String ruleCondition = rule.getDprRuleCondition();
        switch (DprRuleConditionEnum.valueOf(ruleCondition)) {
            //"等于", 1
            case Equal:
                //"结束like%xxx", 13
            case EndWith:
                //"以..开始like'xxx%'", 12
            case StartWith:
                //"包含Like%xxx%", 11
            case Contain:
                //"小于", 6
            case LessThan:
                //"小于等于", 5
            case LessEqual:
                //"大于", 4
            case GreaterThan:
                //"大于等于", 3
            case GreaterEqual:
                //"不等", 2
            case NotEqual:
                mapBuilderFieldValueOne(mapBuilder, value, rule);
                break;

            //"在和之间", 14
            case Between:
                //"不在..和..之间", 15
            case NotBetween:
                mapBuilderFieldValueTwo(mapBuilder, value, rule);
                break;

            //" 在列表中in", 16
            case InList:
                //"不在某个集合内notin", 17
            case NotIn:
                mapBuilderFieldValueMulti(mapBuilder, value, rule);
                break;
            default:
                DataPermissionRuleServiceUtil.throwRuntimeException("非法的运算符设置，请尽快联系管理员。：", rule);


        }
    }

    /**
     * @param @param null
     * @return
     * @description 字段设置值和规则， 多值
     */
    private static void mapBuilderFieldValueMulti(MapBuilder mapBuilder, String value, SysDprRoleApiDataRuleListQueryDTO rule) {
        String[] values = value.split(",");
        if (values.length == 0) {
            throwRuntimeException("错误的规则值参数，请尽快联系管理员。：", rule);
        }
        ArrayList<String> stringList = new ArrayList<>(values.length);
        Collections.addAll(stringList, values);
        mapBuilder.field(rule.getDprRuleField(), stringList).op(rule.getDprRuleCondition());
    }

    /**
     * @param @param null
     * @return
     * @description 字段设置值和规则， 只有一个值
     */
    private static void mapBuilderFieldValueOne(MapBuilder mapBuilder, String value, SysDprRoleApiDataRuleListQueryDTO rule) {
        mapBuilder.field(rule.getDprRuleField(), value).op(rule.getDprRuleCondition());
    }

    /**
     * @param @param null
     * @return
     * @description 字段设置值和规则， 只有二个值
     */
    private static void mapBuilderFieldValueTwo(MapBuilder mapBuilder, String value, SysDprRoleApiDataRuleListQueryDTO rule) {
        String[] values = value.split(",");
        if (values.length <= 1) {
            throwRuntimeException("错误的规则值参数，请尽快联系管理员。：", rule);
        }
        ArrayList<String> stringList = new ArrayList<>(values.length);
        Collections.addAll(stringList, values);
        mapBuilder.field(rule.getDprRuleField(), stringList).op(rule.getDprRuleCondition());
    }
}
