package com.elitescloud.boot.datasecurity.support;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.constant.WebConstant;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * 字段权限拦截器.
 * <p>
 * 自动对权限字段进行清洗
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/17
 */
@ControllerAdvice
@Order(Ordered.LOWEST_PRECEDENCE)
public class FieldPermissionInterceptor implements ResponseBodyAdvice<Object> {

    @Override
    public boolean supports(@NonNull MethodParameter returnType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        var request = HttpServletUtil.currentRequest();
        if (request == null) {
            return false;
        }

        var businessOperation = (BusinessObjectOperation) request.getAttribute(WebConstant.ATTRIBUTE_BUSINESS_OPERATION);
        return businessOperation != null && businessOperation.dataPermissionEnabled() && businessOperation.fieldPermissionAutoFilter();
    }

    @Override
    public Object beforeBodyWrite(Object body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType,
                                  @NonNull Class<? extends HttpMessageConverter<?>> selectedConverterType,
                                  @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        DataSecurityUtil.eraseByFieldPermission(body);
        return body;
    }


}
