/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.jpa.strategy;

import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.jpa.strategy.RuleStrategy;
import com.elitescloud.boot.datasecurity.jpa.strategy.intgerStrategy.IntegerEqualStrategy;
import com.elitescloud.boot.datasecurity.jpa.strategy.intgerStrategy.IntegerInStrategy;
import com.elitescloud.boot.datasecurity.jpa.strategy.longStrategy.LongEqualStrategy;
import com.elitescloud.boot.datasecurity.jpa.strategy.longStrategy.LongInStrategy;
import com.elitescloud.boot.datasecurity.jpa.strategy.stringStrategy.StringContainStrategy;
import com.elitescloud.boot.datasecurity.jpa.strategy.stringStrategy.StringEqualStrategy;
import com.elitescloud.boot.datasecurity.jpa.strategy.stringStrategy.StringInStrategy;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RuleStrategyManager {
    private static final Logger log = LoggerFactory.getLogger(RuleStrategyManager.class);
    private static final Map<String, RuleStrategy> strategies = new HashMap<String, RuleStrategy>();

    private RuleStrategyManager() {
    }

    public static Predicate getPathAutomatically(PathBuilder<?> entityPath, SysDprRoleApiDataRuleListQueryDTO sysRule) {
        try {
            String fieldName = sysRule.getDprRuleField();
            String ruleCondition = sysRule.getDprRuleCondition();
            String ruleValue = sysRule.getDprRuleValue();
            return RuleStrategyManager.getPredicate(entityPath, fieldName, ruleCondition, ruleValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u6570\u636e\u6743\u9650\u5f02\u5e38: ", e);
        }
    }

    private static Predicate getPredicate(PathBuilder<?> entityPath, String fieldName, String ruleCondition, String ruleValue) {
        Assert.hasText((String)ruleCondition, (String)"\u6761\u4ef6\u4e3a\u7a7a");
        String fieldType = RuleStrategyManager.getFieldType(entityPath.getType(), fieldName);
        String key = fieldType + ruleCondition;
        RuleStrategy strategy = strategies.get(key);
        if (strategy == null) {
            throw new IllegalStateException("\u6ca1\u6709\u5bf9\u5e94\u89c4\u5219\u7684key: " + key);
        }
        return strategy.applyRule(entityPath, fieldName, ruleValue);
    }

    private static String getFieldType(Class<?> entityClass, String fieldName) {
        try {
            Field field = RuleStrategyManager.getFieldIncludingParentClasses(entityClass, fieldName);
            return field.getType().getSimpleName();
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("\u5b57\u6bb5\u6ca1\u6709\u627e\u5230: " + fieldName, e);
        }
    }

    private static Field getFieldIncludingParentClasses(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return RuleStrategyManager.getFieldIncludingParentClasses(superClass, fieldName);
        }
    }

    static {
        strategies.put("Long" + DprRuleConditionEnum.Equal.name(), new LongEqualStrategy());
        strategies.put("Long" + DprRuleConditionEnum.InList.name(), new LongInStrategy());
        strategies.put("String" + DprRuleConditionEnum.Equal.name(), new StringEqualStrategy());
        strategies.put("String" + DprRuleConditionEnum.InList.name(), new StringInStrategy());
        strategies.put("String" + DprRuleConditionEnum.Contain.name(), new StringContainStrategy());
        strategies.put("Integer" + DprRuleConditionEnum.Equal.name(), new IntegerEqualStrategy());
        strategies.put("Integer" + DprRuleConditionEnum.InList.name(), new IntegerInStrategy());
    }
}

