/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.support;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
@Order(value=0x7FFFFFFF)
public class FieldPermissionInterceptor
implements ResponseBodyAdvice<Object> {
    public boolean supports(@NonNull MethodParameter returnType, @NonNull Class<? extends HttpMessageConverter<?>> converterType) {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return false;
        }
        BusinessObjectOperation businessOperation = (BusinessObjectOperation)request.getAttribute("cloudt-businessObject-operation");
        return businessOperation != null && businessOperation.dataPermissionEnabled() && businessOperation.fieldPermissionAutoFilter();
    }

    public Object beforeBodyWrite(Object body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType, @NonNull Class<? extends HttpMessageConverter<?>> selectedConverterType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        DataSecurityUtil.eraseByFieldPermission(body);
        return body;
    }
}

