/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.dpr.content;

import com.elitescloud.boot.datasecurity.dpr.content.BasicUdcEnumInterface;
import com.elitescloud.cloudt.system.vo.DprUdcVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DprRuleValueTypeEnum implements BasicUdcEnumInterface
{
    DPR_RULE_VALUE_TYPE_SYS("cloudt-system", "DPR_RULE_VALUE_TYPE", "\u89c4\u5219\u503c\u7c7b\u578b", "\u7cfb\u7edf\u5185\u7f6e\u89c4\u5219", 1),
    DPR_RULE_VALUE_TYPE_CUSTOM("cloudt-system", "DPR_RULE_VALUE_TYPE", "\u89c4\u5219\u503c\u7c7b\u578b", "\u81ea\u5b9a\u4e49\u89c4\u5219", 3),
    DPR_RULE_VALUE_TYPE_BUSINESS("cloudt-system", "DPR_RULE_VALUE_TYPE", "\u89c4\u5219\u503c\u7c7b\u578b", "\u6307\u5b9a\u8fc7\u6ee4\u89c4\u5219", 2);

    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String valueDescription;
    private final int sortNo;
    private final DprUdcVO sysUdcVO;
    private static final Map<String, DprRuleValueTypeEnum> ALL;

    private DprRuleValueTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.valueDescription = description;
        this.sysUdcVO = this.newUdcVo(domainCode, udcCode, udcName, description, sortNo, this.name());
    }

    @Override
    public DprUdcVO getUdcVO() {
        return this.sysUdcVO;
    }

    @Override
    public String getValueDescription() {
        return this.valueDescription;
    }

    public static DprRuleValueTypeEnum parse(String v) {
        return ALL.get(v);
    }

    public static String getValue(String key) {
        for (DprRuleValueTypeEnum ele : DprRuleValueTypeEnum.values()) {
            if (!ele.name().equals(key)) continue;
            return ele.getValueDescription();
        }
        return null;
    }

    public static List<DprUdcVO> getSysUdcVOList() {
        ArrayList<DprUdcVO> sysUdcVOList = new ArrayList<DprUdcVO>();
        for (DprRuleValueTypeEnum ele : DprRuleValueTypeEnum.values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }

    static {
        ALL = Arrays.asList(DprRuleValueTypeEnum.values()).stream().collect(Collectors.toMap(Enum::name, Function.identity(), (t1, t2) -> t1));
    }
}

