/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.DprValid;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.datasecurity.common.extension.DataSecurityCustomizer;
import com.elitescloud.boot.datasecurity.common.extension.FieldPermissionExtension;
import com.elitescloud.boot.datasecurity.config.DataSecurityProperties;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.jpa.strategy.RuleStrategyManager;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.boot.util.BeanWrapperUtil;
import com.elitescloud.boot.util.BusinessObjectUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.boot.util.StrUtil;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.BaseDataSecurityRuleDTO;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DataSecurityUtil {
    private static final Logger logger = CloudtBootLoggerFactory.SECURITY_DATA.getLogger(DataSecurityUtil.class);
    private static RoleDataPermissionRuleService roleDataPermissionRuleService;
    private static DataSecurityCustomizer dataSecurityCustomizer;
    private static DataSecurityProperties dataSecurityProperties;
    private static List<FieldPermissionExtension> fieldPermissionExtensions;
    private static final Map<String, EntityPathBase<?>> entityPathBaseMap;
    private static final InheritableThreadLocal<BusinessContext> BUSINESS_CONTEXT;

    private DataSecurityUtil() {
    }

    public static Predicate predicateForJPA(@NotNull Class<?> entityClass) {
        return DataSecurityUtil.predicateForJPA(entityClass, null, new String[0]);
    }

    public static Predicate predicateForJPA(@NotNull Class<?> entityClass, String alias, String ... ruleFieldName) {
        if (DataSecurityUtil.isAllPermissionUser()) {
            return new BooleanBuilder(null);
        }
        Assert.notNull(entityClass, (String)"\u5b9e\u4f53\u7c7b\u4e3a\u7a7a");
        if (CharSequenceUtil.isBlank((CharSequence)alias)) {
            String entityName = entityClass.getSimpleName();
            alias = entityName.substring(0, 1).toLowerCase() + entityName.substring(1);
        }
        try {
            SysDprRoleApiRowColumnRuleDTO userRoleDpr = DataSecurityUtil.queryDataPermission();
            return DataSecurityUtil.getAuthJpaPredicate(userRoleDpr, entityClass, (String)alias, ruleFieldName);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u6743\u9650\u6761\u4ef6\u751f\u6210\u5f02\u5e38\uff1a{}", (Object)entityClass.getName(), (Object)e);
            return DataSecurityUtil.defaultPredicate();
        }
    }

    public static void eraseByFieldPermission(Object data) {
        if (DataSecurityUtil.isAllPermissionUser()) {
            return;
        }
        if (ObjUtil.isEmpty((Object)data)) {
            return;
        }
        Set<String> fieldNames = DataSecurityUtil.getUnreadableFields();
        if (fieldNames.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        ObjUtil.unwrap((Object)data, d -> {
            HashSet<String> eraseFieldNames = new HashSet<String>(fieldNames);
            eraseFieldNames.addAll(DataSecurityUtil.getUnreadableFieldsByExtension(d, Collections.unmodifiableSet(fieldNames)));
            DataSecurityUtil.eraseObjectValue(d, eraseFieldNames, DataSecurityUtil.getDataSecurityProperties().getFieldPermission().getPlaceholder());
            List detailFields = BeanWrapperUtil.getFieldsByAnnotation((Object)d, DprValid.class);
            if (!detailFields.isEmpty()) {
                String[] detailFieldNames = (String[])detailFields.stream().map(BeanWrapperUtil.CustomField::getName).toArray(String[]::new);
                Map detailValueMap = BeanWrapperUtil.getFieldValue((Object)d, (String[])detailFieldNames);
                for (Object detailValue : detailValueMap.values()) {
                    DataSecurityUtil.eraseByFieldPermission(detailValue);
                }
            }
        });
        if (logger.isErrorEnabled()) {
            logger.debug("erase cost {}ms  by field permission", (Object)(System.currentTimeMillis() - start));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeByTargetBusiness(String businessObjectCode, String businessOperationCode, @NotNull Supplier<T> executor) {
        if (DataSecurityUtil.isAllPermissionUser()) {
            return executor.get();
        }
        BusinessContext parentContext = (BusinessContext)BUSINESS_CONTEXT.get();
        BUSINESS_CONTEXT.set(new BusinessContext(businessObjectCode, businessOperationCode));
        try {
            T t = executor.get();
            return t;
        }
        finally {
            if (parentContext == null) {
                BUSINESS_CONTEXT.remove();
            } else {
                BUSINESS_CONTEXT.set(parentContext);
            }
        }
    }

    public static SysDprRoleApiRowColumnRuleDTO getDataPermission() {
        if (DataSecurityUtil.isAllPermissionUser()) {
            return null;
        }
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        if (currentUser == null) {
            return null;
        }
        return DataSecurityUtil.queryDataPermission();
    }

    public static SysDprRoleApiRowColumnRuleDTO getAllDataPermission() {
        if (DataSecurityUtil.isAllPermissionUser()) {
            return null;
        }
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        if (currentUser == null) {
            return null;
        }
        return DataSecurityUtil.getRoleDataPermissionRuleService().getOriginalDataPermission();
    }

    public static List<SysDpcRoleApiFieldsDTO> getFieldPermission() {
        if (DataSecurityUtil.isAllPermissionUser()) {
            return Collections.emptyList();
        }
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        if (currentUser == null) {
            return Collections.emptyList();
        }
        DataSecurityProperties prop = DataSecurityUtil.getDataSecurityProperties();
        if (Boolean.FALSE.equals(prop.getEnabled()) || Boolean.FALSE.equals(prop.getFieldPermission().getEnabled())) {
            logger.info("[DataFieldSecurity]disabled");
            return Collections.emptyList();
        }
        SysDprRoleApiRowColumnRuleDTO dataPermission = DataSecurityUtil.queryDataPermission();
        if (dataPermission == null || CollUtil.isEmpty((Collection)dataPermission.getSysDpcRoleApiFieldsDTOList())) {
            logger.info("[DataFieldSecurity]no matched rules");
            return Collections.emptyList();
        }
        boolean conflictShow = Boolean.TRUE.equals(DataSecurityUtil.getDataSecurityProperties().getConflictShow());
        return new ArrayList<SysDpcRoleApiFieldsDTO>(dataPermission.getSysDpcRoleApiFieldsDTOList().stream().collect(Collectors.toMap(t -> DataSecurityUtil.normalizeFieldName(t.getFieldName()), t -> {
            t.setFieldName(DataSecurityUtil.normalizeFieldName(t.getFieldName()));
            return t;
        }, (t1, t2) -> {
            if (conflictShow) {
                if (Boolean.TRUE.equals(t1.getReadable())) {
                    if (Boolean.TRUE.equals(t2.getReadable())) {
                        return Boolean.TRUE.equals(t1.getWriteable()) ? t1 : t2;
                    }
                    return t1;
                }
                return Boolean.TRUE.equals(t2.getReadable()) ? t2 : t1;
            }
            if (Boolean.FALSE.equals(t1.getReadable())) {
                if (Boolean.FALSE.equals(t2.getReadable())) {
                    return Boolean.FALSE.equals(t1.getWriteable()) ? t1 : t2;
                }
                return t1;
            }
            return Boolean.FALSE.equals(t2.getReadable()) ? t2 : t1;
        })).values());
    }

    public static boolean isAllPermissionUser() {
        Set<String> allPermissionCodes;
        DataSecurityCustomizer customizer;
        BusinessObjectOperation businessOperation;
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            return true;
        }
        if (user.isSystemAdmin() || user.isTenantAdmin()) {
            return true;
        }
        HttpServletRequest request = HttpServletUtil.currentRequest();
        BusinessObjectOperation businessObjectOperation = businessOperation = request == null ? null : (BusinessObjectOperation)request.getAttribute("cloudt-businessObject-operation");
        if (businessOperation != null && !businessOperation.dataPermissionEnabled()) {
            return true;
        }
        if (CollUtil.isEmpty((Collection)user.getUser().getRoles())) {
            return false;
        }
        String allPermissionCode = DataSecurityUtil.getDataSecurityProperties().getAllPermissionRole();
        if (StrUtil.isNotBlank((CharSequence)allPermissionCode)) {
            for (IdCodeNameParam role : user.getUser().getRoles()) {
                if (!allPermissionCode.equals(role.getCode())) continue;
                return true;
            }
        }
        if ((customizer = DataSecurityUtil.getDataSecurityCustomizer()) != null && !(allPermissionCodes = customizer.getRoleCodesOfAllPermission()).isEmpty()) {
            for (IdCodeNameParam role : user.getUser().getRoles()) {
                if (!allPermissionCodes.contains(role.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    public static DprRuleRelationEnum getRelation(List<SysDprRoleApiDataRuleListQueryDTO> ruleList) {
        DprRuleRelationEnum relation = null;
        for (SysDprRoleApiDataRuleListQueryDTO rule : ruleList) {
            if (Boolean.TRUE.equals(rule.getRuleGroup())) continue;
            relation = DprRuleRelationEnum.valueOf(rule.getDprRuleRelation());
            break;
        }
        if (relation == null) {
            relation = DprRuleRelationEnum.DPR_RULE_RELATION_AND;
        }
        return relation;
    }

    public static String normalizeFieldName(String fieldName) {
        if (StrUtil.isBlank((CharSequence)fieldName)) {
            return fieldName;
        }
        int index = fieldName.lastIndexOf(".");
        return index < 0 ? fieldName : fieldName.substring(index + 1);
    }

    private static Predicate defaultPredicate() {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            return new BooleanBuilder(null);
        }
        DataSecurityProperties props = DataSecurityUtil.getDataSecurityProperties();
        if (Boolean.FALSE.equals(props.getEnabled())) {
            logger.info("[DataSecurity]disabled");
            return new BooleanBuilder(null);
        }
        if (Boolean.TRUE.equals(props.getDefaultAllow())) {
            logger.info("[DataSecurity] default allow");
            return new BooleanBuilder(null);
        }
        logger.info("[DataSecurity] no permission");
        return Expressions.asNumber((Number)1).ne((Object)1);
    }

    private static SysDprRoleApiRowColumnRuleDTO queryDataPermission() {
        String businessObjectCode = null;
        String businessOperationCode = null;
        BusinessContext businessContext = (BusinessContext)BUSINESS_CONTEXT.get();
        if (businessContext != null) {
            businessObjectCode = businessContext.businessObjectCode;
            businessOperationCode = businessContext.businessOperationCode;
        } else {
            HttpServletRequest request = HttpServletUtil.currentRequest();
            businessObjectCode = BusinessObjectUtil.obtainBusinessObjectCode((HttpServletRequest)request);
            businessOperationCode = BusinessObjectUtil.obtainBusinessOperationCode((HttpServletRequest)request);
        }
        RoleDataPermissionRuleService service = DataSecurityUtil.getRoleDataPermissionRuleService();
        if (StringUtils.hasText((String)businessObjectCode) || StringUtils.hasText((String)businessOperationCode)) {
            SysDprRoleApiRowColumnRuleDTO dataPermission = service.getOriginalDataPermission();
            if (dataPermission == null) {
                return null;
            }
            return service.matchDataPermission(dataPermission, businessObjectCode, businessOperationCode);
        }
        return service.getMatchedDataPermission();
    }

    private static void eraseObjectValue(@NotNull Object data, @NotEmpty Set<String> eraseFieldNames, String placeholder) {
        ConfigurablePropertyAccessor propertyAccessor = PropertyAccessorFactory.forDirectFieldAccess((Object)data);
        Class fieldType = null;
        Object value = null;
        for (String fieldName : eraseFieldNames) {
            if (CharSequenceUtil.isBlank((CharSequence)fieldName)) continue;
            try {
                fieldType = propertyAccessor.getPropertyType(fieldName);
                if (fieldType == null) {
                    logger.warn("{}.{}\u4e0d\u5b58\u5728\uff0c\u5c06\u5ffd\u7565", (Object)data.getClass().getName(), (Object)fieldName);
                    continue;
                }
                value = DataSecurityUtil.eraseValue(fieldType, placeholder);
                propertyAccessor.setPropertyValue(fieldName, value);
            }
            catch (BeansException e) {
                logger.warn("\u6570\u636e\u6743\u9650\u6e05\u6d17{}.{}\u5931\u8d25\uff1a", new Object[]{data.getClass().getName(), fieldName, e});
            }
        }
    }

    private static Set<String> getUnreadableFieldsByExtension(Object bean, Set<String> fieldNames) {
        HashSet<String> result = new HashSet<String>();
        Set<String> tempFieldNames = null;
        for (FieldPermissionExtension extension : DataSecurityUtil.getFieldPermissionExtensions()) {
            try {
                tempFieldNames = extension.getUnreadableFields(bean, fieldNames);
            }
            catch (Exception e) {
                logger.error("{}\u83b7\u53d6\u4e0d\u53ef\u8bfb\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38\uff1a", (Object)extension.getClass().getName(), (Object)e);
                continue;
            }
            if (!CollUtil.isNotEmpty(tempFieldNames)) continue;
            result.addAll(tempFieldNames);
        }
        return result;
    }

    private static Set<String> getUnreadableFields() {
        List<SysDpcRoleApiFieldsDTO> fields = DataSecurityUtil.getFieldPermission();
        if (fields.isEmpty()) {
            return Collections.emptySet();
        }
        return fields.stream().filter(t -> Boolean.FALSE.equals(t.getReadable())).map(t -> DataSecurityUtil.normalizeFieldName(t.getFieldName())).collect(Collectors.toSet());
    }

    private static Object eraseValue(@NotNull Class<?> type, String placeholder) {
        if (String.class.isAssignableFrom(type)) {
            return CharSequenceUtil.blankToDefault((CharSequence)placeholder, null);
        }
        if (!type.isPrimitive()) {
            return null;
        }
        if (type.equals(Byte.TYPE)) {
            return 0;
        }
        if (type.equals(Short.TYPE)) {
            return 0;
        }
        if (type.equals(Integer.TYPE)) {
            return 0;
        }
        if (type.equals(Long.TYPE)) {
            return 0;
        }
        if (type.equals(Float.TYPE)) {
            return 0;
        }
        if (type.equals(Double.TYPE)) {
            return 0;
        }
        if (type.equals(Character.TYPE)) {
            return 0;
        }
        if (type.equals(Boolean.TYPE)) {
            return false;
        }
        return null;
    }

    private static Predicate getAuthJpaPredicate(SysDprRoleApiRowColumnRuleDTO userRoleDpr, Class<?> entityClass, String alias, String[] ruleFieldName) {
        List<SysDprRoleApiDataRuleListQueryDTO> ruleList;
        List<SysDprRoleApiDataRuleListQueryDTO> list = ruleList = userRoleDpr == null ? Collections.emptyList() : userRoleDpr.getSysDprRoleApiDataRuleListQueryDTO();
        if (ruleList.isEmpty()) {
            logger.info("[DataSecurity]no rules");
            return DataSecurityUtil.defaultPredicate();
        }
        if (ArrayUtil.isNotEmpty((Object[])ruleFieldName)) {
            List<String> ruleFieldNameList = Arrays.asList(ruleFieldName);
            ruleList = ruleList.stream().filter(dpr -> CharSequenceUtil.isNotBlank((CharSequence)dpr.getDprRuleField()) && ruleFieldNameList.contains(dpr.getDprRuleField())).toList();
        }
        if (ruleList.isEmpty()) {
            logger.info("[DataSecurity]no rules for special field");
            return DataSecurityUtil.defaultPredicate();
        }
        PathBuilder entityPath = new PathBuilder(entityClass, alias);
        Map<String, List<SysDprRoleApiDataRuleListQueryDTO>> groupMap = ruleList.stream().collect(Collectors.groupingBy(BaseDataSecurityRuleDTO::getRoleCode));
        ArrayList<Predicate> groupPredicates = new ArrayList<Predicate>();
        Predicate predicate = null;
        for (Map.Entry<String, List<SysDprRoleApiDataRuleListQueryDTO>> entry : groupMap.entrySet()) {
            DprRuleRelationEnum relation = DataSecurityUtil.getRelation(entry.getValue());
            predicate = DataSecurityUtil.buildPredicate(entry.getValue(), relation, entityPath);
            if (predicate == null) continue;
            groupPredicates.add(predicate);
        }
        return ExpressionUtils.anyOf(groupPredicates);
    }

    public static Predicate buildPredicate(List<SysDprRoleApiDataRuleListQueryDTO> ruleList, DprRuleRelationEnum relation, PathBuilder<?> entityPathBuilder) {
        if (CollUtil.isEmpty(ruleList)) {
            return null;
        }
        SubEntityInfo subEntityInfo = DataSecurityUtil.tryObtainSubEntityInfo(ruleList);
        PathBuilder masEntityPathBuilder = entityPathBuilder;
        if (subEntityInfo != null && subEntityInfo.hasSub && !entityPathBuilder.getType().getName().equals(subEntityInfo.entityClassName)) {
            EntityPathBase subQDO = entityPathBaseMap.computeIfAbsent(subEntityInfo.entityClassName, t -> {
                Class<?> entityClass = null;
                try {
                    entityClass = Class.forName(t);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                return new EntityPathBase(entityClass, "child");
            });
            entityPathBuilder = new PathBuilder(subQDO.getType(), subQDO.getMetadata());
        }
        ArrayList<Object> predicateList = new ArrayList<Object>(ruleList.size());
        Predicate predicate = null;
        for (SysDprRoleApiDataRuleListQueryDTO rule : ruleList) {
            if (Boolean.TRUE.equals(rule.getRuleGroup())) {
                predicate = DataSecurityUtil.buildPredicate(rule.getGroupRules(), DprRuleRelationEnum.valueOf(rule.getDprRuleRelation()), entityPathBuilder);
                if (predicate == null) continue;
                predicateList.add(predicate);
                continue;
            }
            if ("DPR_SYS_INTERNALLY_ALL".equals(rule.getDprRuleValue())) {
                predicateList.add(DprRuleConditionEnum.Equal.name().equals(rule.getDprRuleCondition()) || DprRuleConditionEnum.InList.name().equals(rule.getDprRuleCondition()) ? Expressions.booleanTemplate((String)"1=1", (Object[])new Object[0]) : Expressions.booleanTemplate((String)"1<>1", (Object[])new Object[0]));
                continue;
            }
            boolean isSubField = !entityPathBuilder.getType().getName().equals(rule.getEntityClassName());
            PathBuilder tempPathBuilder = entityPathBuilder;
            if (isSubField) {
                EntityPathBase tempQDO = entityPathBaseMap.computeIfAbsent(rule.getEntityClassName(), t -> {
                    Class<?> entityClass = null;
                    try {
                        entityClass = Class.forName(t);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    return new EntityPathBase(entityClass, "child");
                });
                tempPathBuilder = new PathBuilder(tempQDO.getType(), tempQDO.getMetadata());
            }
            if (ReflectUtil.getField((Class)tempPathBuilder.getType(), (String)rule.getDprRuleField()) == null) {
                logger.warn("\u4e0d\u662f\u8868\u4e2d\u5b57\u6bb5\uff0c\u6743\u9650\u5ffd\u7565\uff1a{}, {}", (Object)tempPathBuilder.getType().getName(), (Object)rule.getDprRuleField());
                continue;
            }
            predicate = RuleStrategyManager.getPathAutomatically(tempPathBuilder, rule);
            if (isSubField) {
                predicate = DataSecurityUtil.buildSubPredicate(entityPathBuilder, SubEntityInfo.fromBy(rule), predicate);
            }
            predicateList.add(predicate);
        }
        Predicate predicate2 = predicate = relation == DprRuleRelationEnum.DPR_RULE_RELATION_OR ? ExpressionUtils.anyOf(predicateList) : ExpressionUtils.allOf(predicateList);
        if (subEntityInfo != null && subEntityInfo.hasSub) {
            predicate = DataSecurityUtil.buildSubPredicate(masEntityPathBuilder, subEntityInfo, predicate);
        }
        return predicate;
    }

    private static Predicate buildSubPredicate(PathBuilder<?> masEntityPathBuilder, SubEntityInfo subEntityInfo, Predicate subPredicate) {
        EntityPathBase subQDO = entityPathBaseMap.computeIfAbsent(subEntityInfo.entityClassName, t -> {
            Class<?> entityClass = null;
            try {
                entityClass = Class.forName(t);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return new EntityPathBase(entityClass, "child");
        });
        PathBuilder subEntityPathBuilder = new PathBuilder(subQDO.getType(), subQDO.getMetadata());
        JPQLQuery subQuery = (JPQLQuery)JPAExpressions.select((Expression)subEntityPathBuilder.get(subEntityInfo.relatedMasField)).from(new EntityPath[]{subQDO}).where(new Predicate[]{subPredicate});
        return masEntityPathBuilder.get(subEntityInfo.masField).in((SubQueryExpression)subQuery);
    }

    private static SubEntityInfo tryObtainSubEntityInfo(List<SysDprRoleApiDataRuleListQueryDTO> ruleList) {
        if (CollUtil.isEmpty(ruleList)) {
            return null;
        }
        SubEntityInfo entityInfo = null;
        for (SysDprRoleApiDataRuleListQueryDTO ruleDTO : ruleList) {
            if (Boolean.TRUE.equals(ruleDTO.getRuleGroup())) {
                SubEntityInfo tempEntityInfo = DataSecurityUtil.tryObtainSubEntityInfo(ruleDTO.getGroupRules());
                if (tempEntityInfo == null || !tempEntityInfo.hasSub) {
                    return null;
                }
                if (entityInfo == null) {
                    entityInfo = tempEntityInfo;
                    continue;
                }
                if (entityInfo.entityClassName.equals(tempEntityInfo.entityClassName)) continue;
                return null;
            }
            if (StrUtil.isBlank((CharSequence)ruleDTO.getEntityClassName())) {
                logger.error("\u89c4\u5219\u7684\u5b9e\u4f53\u7c7b\u540d\u79f0\u4e3a\u7a7a");
                return null;
            }
            if (entityInfo == null) {
                entityInfo = SubEntityInfo.fromBy(ruleDTO);
                continue;
            }
            if (entityInfo.entityClassName.equals(ruleDTO.getEntityClassName())) continue;
            return null;
        }
        return entityInfo;
    }

    private static RoleDataPermissionRuleService getRoleDataPermissionRuleService() {
        if (roleDataPermissionRuleService == null) {
            roleDataPermissionRuleService = (RoleDataPermissionRuleService)SpringContextHolder.getBean(RoleDataPermissionRuleService.class);
        }
        return roleDataPermissionRuleService;
    }

    public static DataSecurityCustomizer getDataSecurityCustomizer() {
        if (dataSecurityCustomizer == null) {
            dataSecurityCustomizer = (DataSecurityCustomizer)SpringContextHolder.getBean(DataSecurityCustomizer.class);
        }
        return dataSecurityCustomizer;
    }

    private static DataSecurityProperties getDataSecurityProperties() {
        if (dataSecurityProperties == null) {
            dataSecurityProperties = (DataSecurityProperties)SpringContextHolder.getBean(DataSecurityProperties.class);
        }
        return dataSecurityProperties;
    }

    private static List<FieldPermissionExtension> getFieldPermissionExtensions() {
        if (fieldPermissionExtensions == null) {
            fieldPermissionExtensions = SpringContextHolder.getObjectProvider(FieldPermissionExtension.class).stream().collect(Collectors.toList());
        }
        return fieldPermissionExtensions;
    }

    static {
        entityPathBaseMap = new HashMap(512);
        BUSINESS_CONTEXT = new InheritableThreadLocal();
    }

    private static class BusinessContext {
        private final String businessObjectCode;
        private final String businessOperationCode;

        public BusinessContext(String businessObjectCode, String businessOperationCode) {
            this.businessObjectCode = businessObjectCode;
            this.businessOperationCode = businessOperationCode;
        }
    }

    private static class SubEntityInfo {
        private boolean hasSub;
        private String entityClassName;
        private String relatedMasField;
        private String masField;

        private SubEntityInfo() {
        }

        static SubEntityInfo fromBy(SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
            SubEntityInfo info = new SubEntityInfo();
            info.hasSub = StrUtil.isAllNotBlank((CharSequence[])new CharSequence[]{ruleDTO.getRelatedMasField(), ruleDTO.getMasField()});
            info.entityClassName = ruleDTO.getEntityClassName();
            info.relatedMasField = ruleDTO.getRelatedMasField();
            info.masField = ruleDTO.getMasField();
            return info;
        }
    }
}

