/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.config;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.MapSearcher;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.datasecurity.common.extension.DataSecurityCustomizer;
import com.elitescloud.boot.datasecurity.common.extension.FieldPermissionExtension;
import com.elitescloud.boot.datasecurity.config.DataSecurityProperties;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherPermissionRuleServiceImpl;
import com.elitescloud.boot.datasecurity.dpr.service.RoleDataPermissionRuleService;
import com.elitescloud.boot.datasecurity.dpr.service.impl.RoleDataPermissionRuleCacheServiceImpl;
import com.elitescloud.boot.datasecurity.dpr.service.impl.RoleDataPermissionRuleServiceImpl;
import com.elitescloud.boot.datasecurity.jpa.strategy.RoleRuleJpaService;
import com.elitescloud.boot.datasecurity.support.DataSecurityUdcFilter;
import com.elitescloud.boot.datasecurity.support.FieldPermissionInterceptor;
import com.elitescloud.boot.datasecurity.support.UdcFieldPermissionCleaner;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.system.provider.extend.SysBusinessObjectRpcService;
import com.elitescloud.cloudt.system.service.RoleAppApiDataPermissionRpcService;
import java.util.Collections;
import org.slf4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;

@Import(value={BeanSearchConfig.class, JpaConfig.class})
@EnableConfigurationProperties(value={DataSecurityProperties.class})
class CloudtDataSecurityAutoConfiguration {
    private static final Logger logger = CloudtBootLoggerFactory.SECURITY_DATA.getLogger(CloudtDataSecurityAutoConfiguration.class);
    private final DataSecurityProperties properties;

    public CloudtDataSecurityAutoConfiguration(DataSecurityProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSecurityCustomizer dataSecurityCustomizer() {
        return Collections::emptySet;
    }

    @Bean
    public RoleDataPermissionRuleService roleDataPermissionRuleService(RedisUtils redisUtils, RoleAppApiDataPermissionRpcService roleAppApiDataPermissionRpcService, SysBusinessObjectRpcService businessObjectRpcService, TaskExecutor taskExecutor) {
        RoleDataPermissionRuleCacheServiceImpl dataPermissionRuleCacheInterface = new RoleDataPermissionRuleCacheServiceImpl(redisUtils, roleAppApiDataPermissionRpcService, businessObjectRpcService, taskExecutor);
        return new RoleDataPermissionRuleServiceImpl(dataPermissionRuleCacheInterface, this.properties);
    }

    @Bean
    public DataSecurityUdcFilter dataSecurityUdcFilter() {
        return new DataSecurityUdcFilter(this.properties);
    }

    @Bean
    public FieldPermissionInterceptor fieldPermissionInterceptor() {
        return new FieldPermissionInterceptor();
    }

    @Bean
    public FieldPermissionExtension udcFieldPermissionCleaner() {
        return new UdcFieldPermissionCleaner();
    }

    class JpaConfig {
        JpaConfig() {
        }

        @Bean
        public RoleRuleJpaService roleRuleJpaService() {
            return new RoleRuleJpaService();
        }
    }

    @ConditionalOnClass(value={BeanSearcher.class})
    class BeanSearchConfig {
        BeanSearchConfig() {
        }

        @Bean
        public BeanSearcherPermissionRuleService beanSearcherPermissionRuleService(TenantClientProvider tenantClientProvider) {
            return new BeanSearcherPermissionRuleServiceImpl(tenantClientProvider);
        }

        @Bean
        public BeanSearcherFactory beanSearcherFactory(BeanSearcher beanSearcher, MapSearcher mapSearcher, TenantClientProvider tenantClientProvider, BeanSearcherPermissionRuleService beanSearcherPermissionRuleService) {
            return new BeanSearcherFactory(beanSearcher, mapSearcher, tenantClientProvider, beanSearcherPermissionRuleService);
        }
    }
}

