/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.dpr.service.util;

import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class RoleDatePermissionColumnUtil {
    private static final Logger logger = CloudtBootLoggerFactory.SECURITY_DATA.getLogger(RoleDatePermissionColumnUtil.class);
    public static final String[] GROUP_STR = new String[]{"DPRaa", "DPRbb", "DPRcc", "DPRdd", "DPRee", "DPRff", "DPRgg", "DPRhh", "DPRii", "DPRjj", "DPRkk", "DPRll", "DPRmm", "DPRnn", "DPRoo", "DPRpp", "DPRqq", "DPRrr", "DPRss", "DPRtt", "DPRuu", "DPRvv", "DPRww", "DPRxx", "DPRyy", "DPRzz"};
    public static final String SB_MAP_GROUP_EXPR = MapBuilder.GROUP_EXPR;
    public static final String TENANT_ID_GROUP = "tenantIdGroup";

    public static void setColumnMapBuilder(Field[] fields, List<SysDpcRoleApiFieldsDTO> columnDto, MapBuilder mapBuilder) {
        StringBuilder columnOnlStr = new StringBuilder();
        StringBuilder columnExcludeStr = new StringBuilder();
        List uniqueFields = Arrays.stream(fields).collect(Collectors.collectingAndThen(Collectors.toMap(Field::getName, field -> field, (existing, replacement) -> existing), map -> new ArrayList(map.values())));
        for (Field field2 : uniqueFields) {
            Boolean isApiFiledRule = false;
            for (SysDpcRoleApiFieldsDTO dto : columnDto) {
                if (!field2.getName().equals(dto.getFieldName())) continue;
                if (dto.getFieldApiVisible().booleanValue()) {
                    if (columnOnlStr.length() == 0) {
                        columnOnlStr.append(dto.getFieldName());
                    } else {
                        columnOnlStr.append(",").append(dto.getFieldName());
                    }
                } else if (columnExcludeStr.length() == 0) {
                    columnExcludeStr.append(dto.getFieldName());
                } else {
                    columnExcludeStr.append(",").append(dto.getFieldName());
                }
                isApiFiledRule = true;
                break;
            }
            if (isApiFiledRule.booleanValue()) continue;
            if (columnOnlStr.length() == 0) {
                columnOnlStr.append(field2.getName());
                continue;
            }
            columnOnlStr.append(",").append(field2.getName());
        }
        if (columnOnlStr.length() != 0) {
            mapBuilder.onlySelect(new String[]{columnOnlStr.toString()});
        }
        if (columnExcludeStr.length() != 0) {
            mapBuilder.selectExclude(new String[]{columnExcludeStr.toString()});
        }
    }

    public static String tenantAuthBuilder(TenantClientProvider tenantClientProvider, MapBuilder mapBuilder, Map<String, Object> params) {
        GeneralUserDetails userInfo = SecurityContextUtil.currentUser();
        Long tenantId = -1L;
        if (tenantClientProvider.enabledTenant()) {
            if (userInfo != null && userInfo.getTenantId() != null) {
                tenantId = userInfo.getTenantId();
            } else {
                SysTenantDTO tenant = tenantClientProvider.getSessionTenant();
                if (tenant != null) {
                    tenantId = tenant.getId();
                }
            }
        }
        mapBuilder.group(TENANT_ID_GROUP);
        ((MapBuilder)mapBuilder.field(BaseModel::getTenantId, new Object[]{tenantId})).op((FieldOp)FieldOps.Equal);
        String bsGroupExpr = RoleDatePermissionColumnUtil.getBeanSearcherGroupExpr(params);
        StringBuffer groupExpr = new StringBuffer();
        if (bsGroupExpr != null && bsGroupExpr.length() > 0) {
            groupExpr.append(bsGroupExpr).append("&tenantIdGroup");
        } else {
            groupExpr.append(TENANT_ID_GROUP);
        }
        return groupExpr.toString();
    }

    public static String tenantBuilder(TenantClientProvider tenantClientProvider, MapBuilder mapBuilder, Map<String, Object> params) {
        GeneralUserDetails userInfo = SecurityContextUtil.currentUser();
        Long tenantId = -1L;
        if (tenantClientProvider.enabledTenant()) {
            if (userInfo != null && userInfo.getTenantId() != null) {
                tenantId = userInfo.getTenantId();
            } else {
                SysTenantDTO tenant = tenantClientProvider.getSessionTenant();
                if (tenant != null) {
                    tenantId = tenant.getId();
                }
            }
        }
        String bsGroupExpr = RoleDatePermissionColumnUtil.getBeanSearcherGroupExpr(params);
        StringBuffer groupExpr = new StringBuffer();
        if (bsGroupExpr != null && bsGroupExpr.length() > 0) {
            mapBuilder.group(TENANT_ID_GROUP);
            ((MapBuilder)mapBuilder.field(BaseModel::getTenantId, new Object[]{tenantId})).op((FieldOp)FieldOps.Equal);
            groupExpr.append(bsGroupExpr).append("&tenantIdGroup");
        } else {
            ((MapBuilder)mapBuilder.field(BaseModel::getTenantId, new Object[]{tenantId})).op((FieldOp)FieldOps.Equal);
            groupExpr.append(TENANT_ID_GROUP);
        }
        return groupExpr.toString();
    }

    public static String getBeanSearcherGroupExpr(Map<String, Object> params) {
        return params.get(SB_MAP_GROUP_EXPR) != null ? params.get(SB_MAP_GROUP_EXPR).toString() : null;
    }

    public static void addSetBeanSearcherGroupExpr(Map<String, Object> params, String groupExpr) {
        Object drpGroupExpr = params.get(SB_MAP_GROUP_EXPR);
        params.put(SB_MAP_GROUP_EXPR, String.valueOf(drpGroupExpr) + groupExpr);
    }
}

