/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasecurity.support;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitescloud.boot.datasecurity.common.extension.FieldPermissionExtension;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.annotation.SysCodeName;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.util.StringUtils;

public class UdcFieldPermissionCleaner
implements FieldPermissionExtension {
    private final Map<Class<?>, Set<String>> cache = new HashMap(128);

    @Override
    public Set<String> getUnreadableFields(Object bean, Set<String> unreadableFields) {
        return this.cache.computeIfAbsent(bean.getClass(), c -> this.obtainUdcFields((Class<?>)c, unreadableFields));
    }

    private Set<String> obtainUdcFields(Class<?> clazz, Set<String> eraseFieldNames) {
        Object[] fields = ReflectUtil.getFields(clazz);
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(fields.length);
        SysCode sysCode = null;
        SysCodeName sysCodeName = null;
        String tempFieldName = null;
        for (Object field : fields) {
            sysCode = ((Field)field).getAnnotation(SysCode.class);
            if (sysCode != null) {
                tempFieldName = CharSequenceUtil.blankToDefault((CharSequence)sysCode.nameField(), (String)(((Field)field).getName() + "Name"));
                if (!eraseFieldNames.contains(((Field)field).getName())) continue;
                result.add(tempFieldName);
                continue;
            }
            sysCodeName = ((Field)field).getAnnotation(SysCodeName.class);
            if (sysCodeName == null || !eraseFieldNames.contains(tempFieldName = this.obtainUdcFieldName(sysCodeName, ((Field)field).getName()))) continue;
            result.add(((Field)field).getName());
        }
        return result;
    }

    private String obtainUdcFieldName(SysCodeName sysCodeName, String fieldName) {
        if (StringUtils.hasText((String)sysCodeName.udcField())) {
            return sysCodeName.udcField();
        }
        if (fieldName.endsWith("Name")) {
            return fieldName.substring(0, fieldName.length() - 4);
        }
        return "";
    }
}

