/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.core.security.dataauth.metadata;

import com.elitescloud.cloudt.core.security.dataauth.metadata.DateAuthResultCode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DataAuthResult<T>
implements Serializable {
    private static final long serialVersionUID = -2726880634686362948L;
    private String msg;
    private String errorMsg;
    private boolean success;
    private T data;

    public DataAuthResult() {
    }

    public static <T> DataAuthResult<T> result(boolean flag) {
        if (flag) {
            return DataAuthResult.ok();
        }
        return DataAuthResult.fail();
    }

    public static <T> DataAuthResult<T> result(DateAuthResultCode authResultCode) {
        return DataAuthResult.result(authResultCode, null);
    }

    public static <T> DataAuthResult<T> result(DateAuthResultCode authResultCode, T data) {
        return DataAuthResult.result(authResultCode, null, data);
    }

    public static <T> DataAuthResult<T> result(DateAuthResultCode authResultCode, String msg, T data) {
        boolean success = authResultCode == DateAuthResultCode.SUCCESS;
        return DataAuthResult.builder().msg(msg).errorMsg(authResultCode.getMsg()).data(data).success(success).build();
    }

    public static <T> DataAuthResult<T> ok() {
        return DataAuthResult.ok(null);
    }

    public static <T> DataAuthResult<T> ok(T data) {
        return DataAuthResult.result(DateAuthResultCode.SUCCESS, data);
    }

    public static <T> DataAuthResult<T> ok(T data, String msg) {
        return DataAuthResult.result(DateAuthResultCode.SUCCESS, msg, data);
    }

    public static <T> DataAuthResult<Map<String, T>> okMap(String key, T value) {
        HashMap<String, T> map = new HashMap<String, T>(1);
        map.put(key, value);
        return DataAuthResult.ok(map);
    }

    public static Map<String, Object> toMap(DataAuthResult<?> result) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("msg", result.msg);
        map.put("data", result.data);
        map.put("success", result.success);
        return map;
    }

    public static <T> DataAuthResult<T> fail(DateAuthResultCode authResultCode) {
        return DataAuthResult.result(authResultCode, null);
    }

    public static <T> DataAuthResult<T> fail(String msg) {
        return DataAuthResult.result(DateAuthResultCode.FAIL, msg, null);
    }

    public static DataAuthResult<Object> fail(DateAuthResultCode authResultCode, String msg) {
        if (DateAuthResultCode.SUCCESS == authResultCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + DateAuthResultCode.SUCCESS.getCode());
        }
        return DataAuthResult.result(authResultCode, msg, null);
    }

    public static <T> DataAuthResult<T> fail(DateAuthResultCode authResultCode, T data) {
        if (DateAuthResultCode.SUCCESS == authResultCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + DateAuthResultCode.SUCCESS.getCode());
        }
        return DataAuthResult.result(authResultCode, data);
    }

    public static <T> DataAuthResult<T> fail(DateAuthResultCode authResultCode, T data, String msg) {
        if (DateAuthResultCode.SUCCESS == authResultCode) {
            throw new IllegalArgumentException("\u5931\u8d25\u7ed3\u679c\u72b6\u6001\u7801\u4e0d\u80fd\u4e3a" + DateAuthResultCode.SUCCESS.getCode());
        }
        return DataAuthResult.result(authResultCode, msg, data);
    }

    public static <T> DataAuthResult<Map<String, T>> fail(String key, T value) {
        HashMap<String, T> map = new HashMap<String, T>(1);
        map.put(key, value);
        return DataAuthResult.result(DateAuthResultCode.FAIL, map);
    }

    public static <T> DataAuthResult<T> fail() {
        return DataAuthResult.fail(DateAuthResultCode.FAIL);
    }

    public static <T> DataAuthResultBuilder<T> builder() {
        return new DataAuthResultBuilder();
    }

    public String getMsg() {
        return this.msg;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public T getData() {
        return this.data;
    }

    public DataAuthResult<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public DataAuthResult<T> setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public DataAuthResult<T> setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public DataAuthResult<T> setData(T data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataAuthResult)) {
            return false;
        }
        DataAuthResult other = (DataAuthResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataAuthResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "DataAuthResult(msg=" + this.getMsg() + ", errorMsg=" + this.getErrorMsg() + ", success=" + this.isSuccess() + ", data=" + String.valueOf(this.getData()) + ")";
    }

    public DataAuthResult(String msg, String errorMsg, boolean success, T data) {
        this.msg = msg;
        this.errorMsg = errorMsg;
        this.success = success;
        this.data = data;
    }

    public static class DataAuthResultBuilder<T> {
        private String msg;
        private String errorMsg;
        private boolean success;
        private T data;

        DataAuthResultBuilder() {
        }

        public DataAuthResultBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public DataAuthResultBuilder<T> errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public DataAuthResultBuilder<T> success(boolean success) {
            this.success = success;
            return this;
        }

        public DataAuthResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public DataAuthResult<T> build() {
            return new DataAuthResult<T>(this.msg, this.errorMsg, this.success, this.data);
        }

        public String toString() {
            return "DataAuthResult.DataAuthResultBuilder(msg=" + this.msg + ", errorMsg=" + this.errorMsg + ", success=" + this.success + ", data=" + String.valueOf(this.data) + ")";
        }
    }
}

