package com.elitescloud.boot.datasource;

import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.*;

/**
 * 数据源选择器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/1
 */
@Documented
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
public @interface DataSourceSelector {

    /**
     * 数据源名称
     *
     * @return 数据源名称
     */
    @AliasFor("name")
    String value() default "";

    /**
     * 数据源名称
     *
     * @return 数据源名称
     */
    @AliasFor("value")
    String name() default "";
}
