package com.elitescloud.boot.datasource.config;

import com.elitescloud.boot.datasource.DataSourceSwitchable;
import com.elitescloud.boot.datasource.config.support.CloudtMultiDataSourceAspect;
import com.elitescloud.boot.datasource.config.support.CloudtMultiDataSourceSwitcher;
import com.elitescloud.boot.datasource.config.support.MultiDataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.PlatformTransactionManager;

import javax.sql.DataSource;

/**
 * 多数据源自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/1
 */
@ConditionalOnProperty(prefix = CloudtMultiDataSourceProperties.CONFIG_PREFIX, name = "enabled", havingValue = "true")
@EnableConfigurationProperties(CloudtMultiDataSourceProperties.class)
public class CloudtMultiDataSourceAutoConfiguration {

    @Bean
    @Primary
    public DataSource dataSource(CloudtMultiDataSourceProperties properties) {
        return new MultiDataSource(properties);
    }

    @Bean
    public DataSourceSwitchable dataSourceSwitchableDefault(PlatformTransactionManager transactionManager) {
        return new CloudtMultiDataSourceSwitcher(transactionManager);
    }

    @Bean
    public CloudtMultiDataSourceAspect cloudtMultiDataSourceAspect(CloudtMultiDataSourceSwitcher dataSourceSwitcher) {
        return new CloudtMultiDataSourceAspect(dataSourceSwitcher);
    }
}
