package com.elitescloud.boot.datasource.config.support;

/**
 * 数据源.
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/16
 */
class DataSourceContextHolder {

    private static final ThreadLocal<String> DATASOURCE = new ThreadLocal<>();

    static void setDatasource(String ds) {
        DATASOURCE.set(ds);
    }

    static String getDatasource() {
        return DATASOURCE.get();
    }

    static void clearDatasource() {
        DATASOURCE.remove();;
    }
}
