/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasource.config.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.datasource.DataSourceSwitchable;
import com.elitescloud.boot.datasource.config.support.DataSourceContextHolder;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CloudtMultiDataSourceSwitcher
implements DataSourceSwitchable {
    private static final Logger log = LoggerFactory.getLogger(CloudtMultiDataSourceSwitcher.class);
    private final PlatformTransactionManager transactionManager;

    public CloudtMultiDataSourceSwitcher(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public <T> T execute(Supplier<T> supplier, String dsName) {
        Assert.notNull(supplier, (String)"\u5f85\u6267\u884c\u64cd\u4f5c\u4e3a\u7a7a");
        String beforeName = DataSourceContextHolder.getDatasource();
        log.info("switch dataSource\uff1a{} -> {}", (Object)beforeName, (Object)dsName);
        if (CharSequenceUtil.equals((CharSequence)beforeName, (CharSequence)dsName)) {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        DataSourceContextHolder.setDatasource(dsName);
        String newTransactionName = "cloudt-dynamicDs[" + dsName + "]";
        TransactionStatus transaction = this.buildTenantTransactionDefinition(newTransactionName);
        try {
            T result = supplier.get();
            this.afterCompletion(transaction, null);
            T t = result;
            return t;
        }
        catch (Exception e) {
            this.afterCompletion(transaction, e);
            throw new RuntimeException(e);
        }
        finally {
            if (StringUtils.hasText((String)beforeName)) {
                DataSourceContextHolder.setDatasource(beforeName);
            } else {
                DataSourceContextHolder.clearDatasource();
            }
        }
    }

    private void afterCompletion(TransactionStatus transactionStatus, Exception exp) {
        if (exp == null) {
            this.transactionManager.commit(transactionStatus);
            return;
        }
        this.transactionManager.rollback(transactionStatus);
        log.error("\u6267\u884c\u4e1a\u52a1\u5f02\u5e38\uff1a", (Throwable)exp);
    }

    private TransactionStatus buildTenantTransactionDefinition(String newTransactionName) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(3);
        definition.setName(newTransactionName);
        return this.transactionManager.getTransaction((TransactionDefinition)definition);
    }
}

