package com.elitescloud.boot.datasource;

import javax.validation.constraints.NotNull;
import java.util.function.Supplier;

/**
 * 数据源切换器.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/1
 */
public interface DataSourceSwitchable {

    /**
     * 切换数据源执行操作
     *
     * @param supplier       待执行的操作
     * @param dataSourceName 数据源名称，为空则使用默认数据源
     * @param <T>            结果类型
     * @return 执行结果
     */
    <T> T execute(@NotNull Supplier<T> supplier, String dataSourceName);
}
