package com.elitescloud.boot.datasource.config;

import com.zaxxer.hikari.HikariConfig;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.HashMap;
import java.util.Map;

/**
 * 多数据源配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/1
 */
@ConfigurationProperties(prefix = CloudtMultiDataSourceProperties.CONFIG_PREFIX)
public class CloudtMultiDataSourceProperties {
    public static final String CONFIG_PREFIX = "elitesland.datasource";

    /**
     * 是否启用
     */
    private Boolean enabled = false;

    /**
     * 默认数据源名称
     */
    private String defaultDatasource;

    /**
     * 多数据源配置
     */
    private Map<String, CloudtDataSourceProperties> multi = new HashMap<>();

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getDefaultDatasource() {
        return defaultDatasource;
    }

    public void setDefaultDatasource(String defaultDatasource) {
        this.defaultDatasource = defaultDatasource;
    }

    public Map<String, CloudtDataSourceProperties> getMulti() {
        return multi;
    }

    public void setMulti(Map<String, CloudtDataSourceProperties> multi) {
        this.multi = multi;
    }

    public static class CloudtDataSourceProperties extends DataSourceProperties {
        private HikariConfig hikari = new HikariConfig();

        public HikariConfig getHikari() {
            return hikari;
        }

        public void setHikari(HikariConfig hikari) {
            this.hikari = hikari;
        }
    }
}
