/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasource.config.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.datasource.config.CloudtMultiDataSourceProperties;
import com.elitescloud.boot.datasource.config.support.DataSourceContextHolder;
import com.zaxxer.hikari.HikariDataSource;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MultiDataSource
implements DataSource,
EnvironmentAware,
InitializingBean {
    private static final Logger logger = CloudtBootLoggerFactory.DATASOURCE_MULTI.getLogger(MultiDataSource.class);
    private Environment environment;
    private final CloudtMultiDataSourceProperties properties;
    private final Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(8);
    private DataSource defaultDatasource = null;

    public MultiDataSource(CloudtMultiDataSourceProperties properties) {
        this.properties = properties;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDataSource().getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDataSource().setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDataSource().setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDataSource().getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getDataSource().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getDataSource().isWrapperFor(iface);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.getDataSource().getParentLogger();
    }

    public void setEnvironment(@NonNull Environment environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    private void init() {
        Assert.isTrue((!this.properties.getMulti().isEmpty() ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u591a\u6570\u636e\u7684\u914d\u7f6e");
        String def = this.properties.getDefaultDatasource();
        Assert.hasText((String)def, (String)"\u8bf7\u914d\u7f6e\u9ed8\u8ba4\u6570\u636e\u6e90\u7684\u540d\u79f0");
        Binder binder = Binder.get((Environment)this.environment);
        Properties defaultProperties = this.obtainDefaultProperties(binder);
        this.loadMultiDataSourceProperties(binder, defaultProperties);
        this.defaultDatasource = this.dataSourceMap.get(def);
        Assert.notNull((Object)this.defaultDatasource, (String)("\u9ed8\u8ba4\u6570\u636e\u6e90" + def + "\u4e0d\u5b58\u5728"));
        logger.info("default datasource is: {}", (Object)def);
    }

    private void loadMultiDataSourceProperties(Binder binder, Properties defaultProperties) {
        Set<String> dataSourceNames = this.properties.getMulti().keySet();
        for (String datasourceName : dataSourceNames) {
            logger.info("start loading datasource: {}", (Object)datasourceName);
            String prefix = "elitesland.datasource.multi." + datasourceName;
            BindResult bindResult = binder.bind(prefix, DataSourceProperties.class);
            if (!bindResult.isBound()) {
                throw new IllegalStateException("\u6570\u636e\u6e90" + datasourceName + "\u52a0\u8f7d\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u5df2\u914d\u7f6e");
            }
            DataSourceProperties properties = (DataSourceProperties)bindResult.get();
            HikariDataSource datasource = (HikariDataSource)properties.initializeDataSourceBuilder().type(HikariDataSource.class).build();
            Properties hikariProperties = this.hikariProperties(binder, prefix, defaultProperties);
            if (hikariProperties != null) {
                datasource.setDataSourceProperties(hikariProperties);
            }
            datasource.setPoolName(CharSequenceUtil.blankToDefault((CharSequence)datasource.getPoolName(), (String)("cloudt-ds-" + datasourceName)));
            this.dataSourceMap.put(datasourceName, (DataSource)datasource);
        }
    }

    private Properties obtainDefaultProperties(Binder binder) {
        Properties defaultProperties = this.hikariProperties(binder, "elitesland.datasource", null);
        if (defaultProperties != null) {
            return defaultProperties;
        }
        return this.hikariProperties(binder, "spring.datasource", null);
    }

    private Properties hikariProperties(Binder binder, String prefix, Properties defaultProperties) {
        String name = prefix + ".hikari";
        BindResult bindResult = binder.bind(name, Properties.class);
        if (bindResult.isBound()) {
            Properties properties = (Properties)bindResult.get();
            if (defaultProperties != null) {
                defaultProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::putIfAbsent));
            }
            return properties;
        }
        return defaultProperties;
    }

    private DataSource getDataSource() {
        String ds = DataSourceContextHolder.getDatasource();
        if (StringUtils.hasText((String)ds)) {
            DataSource datasource = this.dataSourceMap.get(ds);
            Assert.notNull((Object)datasource, (String)(ds + "\u6570\u636e\u6e90\u672a\u914d\u7f6e"));
            return datasource;
        }
        return this.defaultDatasource;
    }
}

