/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasource.config;

import com.elitescloud.boot.datasource.DataSourceSwitchable;
import com.elitescloud.boot.datasource.config.CloudtMultiDataSourceProperties;
import com.elitescloud.boot.datasource.config.support.CloudtMultiDataSourceAspect;
import com.elitescloud.boot.datasource.config.support.CloudtMultiDataSourceSwitcher;
import com.elitescloud.boot.datasource.config.support.MultiDataSource;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.PlatformTransactionManager;

@ConditionalOnProperty(prefix="elitesland.datasource", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={CloudtMultiDataSourceProperties.class})
public class CloudtMultiDataSourceAutoConfiguration {
    @Bean
    @Primary
    public DataSource dataSource(CloudtMultiDataSourceProperties properties) {
        return new MultiDataSource(properties);
    }

    @Bean
    public DataSourceSwitchable dataSourceSwitchableDefault(PlatformTransactionManager transactionManager) {
        return new CloudtMultiDataSourceSwitcher(transactionManager);
    }

    @Bean
    public CloudtMultiDataSourceAspect cloudtMultiDataSourceAspect(CloudtMultiDataSourceSwitcher dataSourceSwitcher) {
        return new CloudtMultiDataSourceAspect(dataSourceSwitcher);
    }
}

