/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.datasource.config.support;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.datasource.DataSourceSelector;
import com.elitescloud.boot.datasource.DataSourceSwitchable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.util.Assert;

@Aspect
public class CloudtMultiDataSourceAspect {
    private static final Logger logger = CloudtBootLoggerFactory.DATASOURCE_MULTI.getLogger(CloudtMultiDataSourceAspect.class);
    private final DataSourceSwitchable dataSourceSwitchable;

    public CloudtMultiDataSourceAspect(DataSourceSwitchable dataSourceSwitchable) {
        this.dataSourceSwitchable = dataSourceSwitchable;
    }

    @Pointcut(value="@annotation(com.elitescloud.boot.datasource.DataSourceSelector)")
    private void pointCutMethod() {
    }

    @Pointcut(value="@within(com.elitescloud.boot.datasource.DataSourceSelector)")
    private void pointCutClass() {
    }

    @Around(value="pointCutClass() || pointCutMethod()")
    public Object cutAround(ProceedingJoinPoint point) throws Throwable {
        DataSourceSelector annotation = this.obtainAnnotation(point);
        Assert.notNull((Object)annotation, (String)"\u672a\u83b7\u53d6\u5230Ds\u6ce8\u89e3\u4fe1\u606f");
        String dsName = CharSequenceUtil.blankToDefault((CharSequence)annotation.value(), (String)annotation.name());
        Assert.hasText((String)dsName, () -> "\u672a\u6307\u5b9a\u6570\u636e\u6e90\u540d\u79f0\uff1a" + point.getThis().getClass().getName());
        return this.dataSourceSwitchable.execute(() -> {
            try {
                return point.proceed();
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }, dsName);
    }

    private DataSourceSelector obtainAnnotation(ProceedingJoinPoint point) {
        if (point instanceof MethodInvocationProceedingJoinPoint) {
            DataSourceSelector annotation = ((MethodSignature)point.getSignature()).getMethod().getAnnotation(DataSourceSelector.class);
            if (annotation == null) {
                annotation = point.getThis().getClass().getAnnotation(DataSourceSelector.class);
            }
            return annotation;
        }
        return null;
    }
}

