/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.dubbo.filter;

import cn.hutool.core.util.BooleanUtil;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcServiceContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Activate(group={"provider", "consumer"})
public class DubboTenantContextFilter
implements Filter {
    private static final Logger log = LogManager.getLogger(DubboTenantContextFilter.class);
    private static final String ATTACHMENT_KEY_TENANT_ID = "cloudt_tenant_id";
    private static final ThreadLocal<Boolean> NOT_NEED_TENANT = new ThreadLocal();
    private TenantClientProvider tenantClientProvider;

    public static void setNotNeedTenant() {
        NOT_NEED_TENANT.set(true);
    }

    public static void removeNotNeedTenant() {
        NOT_NEED_TENANT.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        SysTenantDTO tenantDTO;
        RpcServiceContext rpcContext = RpcContext.getServiceContext();
        if (rpcContext.getUrl() == null || !this.tenantClientProvider.enabledTenant()) {
            return invoker.invoke(invocation);
        }
        if (rpcContext.isProviderSide()) {
            SysTenantDTO tenantDTO2 = null;
            String tenantId = rpcContext.getAttachment(ATTACHMENT_KEY_TENANT_ID);
            if (tenantId != null && tenantId.length() > 0 && (tenantDTO2 = this.tenantClientProvider.getTenant(Long.valueOf(Long.parseLong(tenantId)))) != null) {
                this.setTenant(tenantDTO2);
                log.info("\u5f53\u524d\u79df\u6237\uff1a{}", (Object)tenantDTO2.getTenantCode());
            }
            try {
                Result result = invoker.invoke(invocation);
                return result;
            }
            finally {
                if (tenantDTO2 != null) {
                    this.clearTenant();
                }
            }
        }
        if (!BooleanUtil.orOfWrap((Boolean[])new Boolean[]{NOT_NEED_TENANT.get(), TenantSession.getNoTenant()}).booleanValue() && (tenantDTO = this.tenantClientProvider.getSessionTenant()) != null) {
            rpcContext.setAttachment(ATTACHMENT_KEY_TENANT_ID, tenantDTO.getId().toString());
        }
        return invoker.invoke(invocation);
    }

    private void setTenant(SysTenantDTO tenant) {
        TenantContextHolder.setCurrentTenant((SysTenantDTO)tenant);
    }

    private void clearTenant() {
        TenantContextHolder.clearCurrentTenant();
    }

    public void setTenantClientProvider(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }
}

