/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.dubbo.config.handler;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.exception.CustomExceptionTranslate;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class DubboExceptionTranslate
implements CustomExceptionTranslate {
    private static final Logger logger = CloudtBootLoggerFactory.RPC_DUBBO.getLogger(DubboExceptionTranslate.class);
    private static final String EXP_NO_PROVIDER_AVAILABLE = "No provider available";
    private static final String EXP_NO_PROVIDER_AVAILABLE1 = "because channel is closed";
    private static final String EXP_THREAD_POOL_OVERFLOW = "thread pool is exhausted";

    public boolean support(@NonNull Throwable e) {
        return e instanceof RpcException;
    }

    @Nullable
    public ApiResult<String> translate(@NonNull Throwable e) {
        RpcException exception = (RpcException)e;
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)exception);
        if (rootCause instanceof TimeoutException) {
            return ApiResult.fail((ApiCode)ApiCode.REQUEST_TIMEOUT, (String)"\u8bf7\u6c42\u8d85\u65f6");
        }
        String rootCauseMsg = rootCause.getMessage();
        if (CharSequenceUtil.contains((CharSequence)rootCauseMsg, (CharSequence)EXP_NO_PROVIDER_AVAILABLE) || CharSequenceUtil.contains((CharSequence)rootCauseMsg, (CharSequence)EXP_NO_PROVIDER_AVAILABLE1)) {
            return ApiResult.fail((ApiCode)ApiCode.NO_PROVIDER, (String)"\u7cfb\u7edf\u7ef4\u62a4\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        if (CharSequenceUtil.contains((CharSequence)rootCauseMsg, (CharSequence)EXP_THREAD_POOL_OVERFLOW)) {
            return ApiResult.fail((ApiCode)ApiCode.THREAD_POOL_OVERFLOW, (String)"\u5f53\u524d\u8bbf\u95ee\u7528\u6237\u8fc7\u591a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return ApiResult.fail((ApiCode)ApiCode.PROVIDER_EXCEPTION);
    }
}

