package com.elitescloud.boot.excel.common;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;

import java.io.Serializable;

/**
 * 数据导出接口.
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/15
 */
public interface DataExport<T extends Serializable, E extends AbstractOrderQueryParam> {

    /**
     * 获取模板编号
     *
     * @return 模板编号
     */
    String getTmplCode();

    /**
     * 导出数据
     *
     * @param queryParam 查询参数
     * @param page       页数，从1开始
     * @param pageSize   页大小
     * @return 数据
     */
    PagingVO<T> execute(E queryParam, int page, int pageSize);

    /**
     * 导出文件的名称
     *
     * @return 导出文件的名称
     */
    default String exportFileName() {
        return null;
    }

    /**
     * 分页查询时每次查询数量
     *
     * @return 页大小
     */
    default Integer pageSize() {
        return 50;
    }
}
