package com.elitescloud.boot.excel.config.tmpl.export.strategy;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.excel.config.tmpl.export.ExportStrategyParam;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.config.tmpl.params.TmplRateDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

import java.util.List;

/**
 * 超出sheet限制后剩余的数据忽略.
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/28
 */
class IgnoreExportStrategy extends BaseExportStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreExportStrategy.class);

    public IgnoreExportStrategy(FileService<?> fileService, SystemTmplDataSupport fsmTmplSupport, ObjectMapper objectMapper) {
        super(fileService, fsmTmplSupport, objectMapper);
    }

    @Override
    public long export(ExportStrategyParam param) {
        int sheetLimit = sheetLimit(param.getTmplDTO());
        int page = 2;
        var pageSize = super.obtainPageSize(param.getDataExport());
        int count = 0;

        var excelFile = createExportFile(param);
        StopWatch watch = new StopWatch();
        watch.start();

        var excelWriter = EasyExcel.write(excelFile).build();
        WriteSheet sheet = EasyExcel.writerSheet(0).sheetName("Sheet 1").build();
        // 头部
        excelWriter.write(obtainHeaders(param.getTmplDTO()), sheet);

        // 开始写数据
        var pageData = param.getFirstPageData();
        List<List<String>> writeDataList;
        var attributes = obtainAttributes(param.getTmplDTO());

        while (pageData.isNotEmpty()) {
            var tempDataList = pageData.getRecords();
            if (count + pageData.size() > sheetLimit) {
                // 超出限制了，截取一部分，忽略多余的
                tempDataList = pageData.getRecords().subList(0, sheetLimit - count);
            }
            count += tempDataList.size();
            writeDataList = convertExportData(tempDataList, attributes);
            excelWriter.write(writeDataList, sheet);

            // 少于页大小，则说明没有数据了
            var isFinish = pageData.size() < pageSize || count == sheetLimit;
            if (!param.isSync()) {
                // 异步时更新进度
                super.updateRate(param.getImportId(), TmplRateDTO.builder()
                        .finish(isFinish)
                        .total(pageData.getTotal())
                        .count((long) count)
                        .tmplCode(param.getTmplDTO().getCode())
                        .build());
            }
            if (isFinish) {
                break;
            }

            param.getQueryParam().setCurrent(page);
            param.getQueryParam().setSize(pageSize);
            pageData = param.getDataExport().execute(param.getQueryParam(), page, pageSize);
            page++;
        }
        excelWriter.finish();
        watch.stop();

        // 更新导出结果
        updateExportFinish(param, (long) count, "导出成功", excelFile);
        LOG.info(param.getImportId() + "导出结束耗时：" + watch.getTotalTimeMillis());
        excelFile.deleteOnExit();

        return count;
    }
}
