package com.elitescloud.boot.excel.config.tmpl.params;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * 导入导出进度.
 *
 * @author Kaiser（wang shao）
 * @date 3/20/2023
 */
@Data
@Builder
public class TmplRateDTO implements Serializable {

    public TmplRateDTO(Boolean finish, String tmplCode, Long total, Long count) {
        this.finish = finish;
        this.tmplCode = tmplCode;
        this.total = total;
        this.count = count;
    }

    public TmplRateDTO() {
    }

    /**
     * 是否导入完毕
     */
    private Boolean finish;

    /**
     * 导入模板编号
     */
    private String tmplCode;

    /**
     * 记录总数
     */
    private Long total;

    /**
     * 已导入数量
     */
    private Long count;
}
