/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataExportServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(DataExportServiceFactory.class);
    private final Map<String, ServiceMetaData> dataExportMap = new HashMap<String, ServiceMetaData>(64);

    public DataExportServiceFactory(List<DataExport<?, ?>> dataExportList) {
        this.init(dataExportList);
    }

    public boolean isSupport(String tmplCode) {
        return this.dataExportMap.containsKey(tmplCode);
    }

    public ServiceMetaData getDataExportService(String tmplCode) {
        return this.dataExportMap.get(tmplCode);
    }

    private void init(List<DataExport<?, ?>> dataExportList) {
        if (CollUtil.isEmpty(dataExportList)) {
            return;
        }
        for (DataExport<?, ?> DataExport2 : dataExportList) {
            if (this.dataExportMap.containsKey(DataExport2.getTmplCode())) {
                throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u5bfc\u51fa\u670d\u52a1\uff1a" + DataExport2.getTmplCode());
            }
            this.dataExportMap.put(DataExport2.getTmplCode(), new ServiceMetaData(DataExport2));
        }
    }

    public static class ServiceMetaData {
        private final DataExport<Serializable, AbstractOrderQueryParam> dataExport;
        private final Class<? extends Serializable> dataType;
        private final Class<? extends AbstractOrderQueryParam> paramType;

        public ServiceMetaData(DataExport<?, ?> dataExport) {
            this.dataExport = dataExport;
            Type[] arguments = ((ParameterizedType)dataExport.getClass().getGenericInterfaces()[0]).getActualTypeArguments();
            this.dataType = (Class)arguments[0];
            this.paramType = (Class)arguments[1];
        }

        public DataExport<Serializable, AbstractOrderQueryParam> getDataExport() {
            return this.dataExport;
        }

        public Class<? extends Serializable> getDataType() {
            return this.dataType;
        }

        public Class<? extends AbstractOrderQueryParam> getParamType() {
            return this.paramType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServiceMetaData)) {
                return false;
            }
            ServiceMetaData other = (ServiceMetaData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DataExport<Serializable, AbstractOrderQueryParam> this$dataExport = this.getDataExport();
            DataExport<Serializable, AbstractOrderQueryParam> other$dataExport = other.getDataExport();
            if (this$dataExport == null ? other$dataExport != null : !this$dataExport.equals(other$dataExport)) {
                return false;
            }
            Class<? extends Serializable> this$dataType = this.getDataType();
            Class<? extends Serializable> other$dataType = other.getDataType();
            if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
                return false;
            }
            Class<? extends AbstractOrderQueryParam> this$paramType = this.getParamType();
            Class<? extends AbstractOrderQueryParam> other$paramType = other.getParamType();
            return !(this$paramType == null ? other$paramType != null : !this$paramType.equals(other$paramType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServiceMetaData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DataExport<Serializable, AbstractOrderQueryParam> $dataExport = this.getDataExport();
            result = result * 59 + ($dataExport == null ? 43 : $dataExport.hashCode());
            Class<? extends Serializable> $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            Class<? extends AbstractOrderQueryParam> $paramType = this.getParamType();
            result = result * 59 + ($paramType == null ? 43 : $paramType.hashCode());
            return result;
        }

        public String toString() {
            return "DataExportServiceFactory.ServiceMetaData(dataExport=" + this.getDataExport() + ", dataType=" + this.getDataType() + ", paramType=" + this.getParamType() + ")";
        }
    }
}

