package com.elitescloud.boot.excel.common.support;

import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.elitescloud.cloudt.system.dto.req.RecordResultSaveDTO;
import com.elitescloud.cloudt.common.base.ApiResult;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

/**
 * 模板API服务.
 *
 * @author Kaiser（wang shao）
 * @date 3/20/2023
 */
public interface TmplApiService {

    /**
     * 根据模板编号获取模板信息
     *
     * @param code 模板编号
     * @return 模板信息
     */
    ApiResult<SysTmplDTO> getByCode(@NotBlank String code);

    /**
     * 根据模板编号获取模板文件的编号
     *
     * @param code 模板编号
     * @return 模板信息
     */
    ApiResult<String> getFileCodeByCode(@NotBlank String code);

    /**
     * 保存导入导出记录
     *
     * @param code           模板编号
     * @param recordFileCode 导入导出记录的文件编码
     * @param queryParam     导出时的请求参数
     * @return 记录ID
     */
    ApiResult<Long> saveRecord(@NotBlank String code, String recordFileCode, Map<String, Object> queryParam);

    /**
     * 更新总数
     *
     * @param recordId 记录标识
     * @param numTotal 总数
     * @return 记录标识
     */
    ApiResult<Long> updateNumTotal(@NotNull Long recordId, @NotNull Long numTotal);

    /**
     * 更新结果
     *
     * @param resultDTO 结果
     * @return 记录标识
     */
    ApiResult<Long> updateResult(RecordResultSaveDTO resultDTO);

    /**
     * 获取导入进度
     *
     * @param recordId 记录标识
     * @return 导入进度
     */
    ApiResult<SysImportRateDTO> getImportRate(@NotNull Long recordId);

    /**
     * 获取记录的文件标识
     *
     * @param recordId 记录标识
     * @return 文件标识
     */
    ApiResult<String> getRecordFileCode(@NotNull Long recordId);

    /**
     * 获取未导入结束的记录ID
     *
     * @return 记录ID
     */
    ApiResult<List<Long>> queryUnFinished();

    /**
     * 保存导出文件
     *
     * @param recordId 记录ID
     * @param fileCode 文件标识
     * @param order    顺序
     * @return 结果
     */
    ApiResult<Long> saveExportFile(@NotNull Long recordId, @NotNull String fileCode, @NotNull Integer order);
}
