package com.elitescloud.boot.excel.config;

import com.alibaba.excel.EasyExcel;
import com.elitescloud.boot.excel.support.ExportExcelServiceImpl;
import com.elitescloud.cloudt.core.service.ExportExcelService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/18
 */
@EnableConfigurationProperties(ExportExcelProperties.class)
@ConditionalOnClass(EasyExcel.class)
@ConditionalOnProperty(prefix = "elitesland.export", name = "enable", havingValue = "true", matchIfMissing = true)
public class ExportExcelConfig {

    @Bean
    public ExportExcelService exportExcelService(ExportExcelProperties exportExcelProperties,
                                                 TaskExecutor taskExecutor) {
        return new ExportExcelServiceImpl(exportExcelProperties, taskExecutor);
    }
}
