package com.elitescloud.boot.excel.common;


import com.elitescloud.cloudt.system.dto.resp.ImportResultRespVO;

import java.util.List;

/**
 * 数据导入接口.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/3
 */
public interface DataImport<T> {

    /**
     * 获取模板编号
     *
     * @return 模板编号
     */
    String getTmplCode();

    /**
     * 导入数据
     *
     * @param dataList      数据列表
     * @param startRowIndex 开始行索引
     * @return 导入结果
     */
    ImportResultRespVO.SyncResult execute(List<T> dataList, int startRowIndex);

    /**
     * 每次取的数据量
     *
     * @return 数据条数
     */
    default Integer stepSize() {
        return 20;
    }
}
