package com.elitescloud.cloudt.system.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 模板信息.
 *
 * @author Kaiser（wang shao）
 * @date 3/20/2023
 */
@Data
public class SysTmplDTO implements Serializable {
    private static final long serialVersionUID = 3883760492384773258L;

    /**
     * 模板ID
     */
    private Long id;

    /**
     * 模板名称
     */
    private String name;

    /**
     * 模板编号
     */
    private String code;

    /**
     * 模板文件标识
     */
    private String fileCode;

    /**
     * 是否是导出模板
     */
    private Boolean export;

    /**
     * 头部所占行数，头部以下都是数据部分
     */
    private Integer headRow;

    /**
     * 数据字段类型所在行，fieldTypeRow不能大于headRow
     */
    private Integer fieldTypeRow;

    /**
     * 模板文件标识
     */
    private Boolean enabled;

    /**
     * 导入数据限制
     * 每次允许导入的记录数量，-1表示无限制
     */
    private Integer dataLimitPer;

    /**
     * 异步阀值，导入数据超过阀值后将转为异步的方式，-1表示无限制
     */
    private Integer asyncThreshold;

    /**
     * 并发限制，同一模板可并发的最大数量，-1表示无限制
     */
    private Integer concurrentLimit;

    /**
     * 属性列表
     */
    private List<List<String>> attributes;

    /**
     * 导出时sheet页数据量限制，最大100万
     */
    private Integer exportSheetLimit;

    /**
     * 导出时超出sheet限制后的策略
     * {@link com.elitescloud.cloudt.constant.SheetLimitStrategy}
     */
    private String exportSheetStrategy;
}
