/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.config.tmpl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.excel.config.tmpl.DataExportServiceFactory;
import com.elitescloud.boot.excel.config.tmpl.DataImportServiceFactory;
import com.elitescloud.boot.excel.config.tmpl.export.ExportStrategyParam;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.TmplExportStrategyDelegate;
import com.elitescloud.boot.excel.util.ExcelImportUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.dto.req.RecordResultSaveDTO;
import com.elitescloud.cloudt.system.dto.resp.ExportResultRespVO;
import com.elitescloud.cloudt.system.dto.resp.ImportRateRespVO;
import com.elitescloud.cloudt.system.dto.resp.ImportResultRespVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

class TmplDataService
implements ApplicationRunner {
    private static final Logger log = LogManager.getLogger(TmplDataService.class);
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private DataImportServiceFactory dataImportServiceFactory;
    @Autowired
    private DataExportServiceFactory dataExportServiceFactory;
    @Autowired
    private TmplExportStrategyDelegate exportStrategyDelegate;
    private final FileService<?> fileService;
    private final SystemTmplDataSupport fsmTmplSupport;
    private File tempDir = null;

    public TmplDataService(FileService<?> fileService, SystemTmplDataSupport fsmTmplSupport) {
        this.fileService = fileService;
        this.fsmTmplSupport = fsmTmplSupport;
        this.initTempDir();
    }

    public void run(ApplicationArguments args) throws Exception {
        CompletableFuture.runAsync(() -> {
            List<Long> importIds = this.fsmTmplSupport.getUnFinished();
            if (CollUtil.isNotEmpty(importIds)) {
                RecordResultSaveDTO resultSaveDTO = null;
                SysImportRateDTO rateDTO = null;
                for (Long id : importIds) {
                    rateDTO = this.fsmTmplSupport.getImportRateFromCache(id);
                    resultSaveDTO = RecordResultSaveDTO.builder().recordId(id).success(false).failMsg("\u7cfb\u7edf\u5f02\u5e38\u505c\u6b62").build();
                    if (rateDTO != null) {
                        resultSaveDTO.setNumSuc(rateDTO.getCount());
                    }
                    this.fsmTmplSupport.updateImportResult(resultSaveDTO);
                }
            }
        }, (Executor)this.taskExecutor).exceptionally(throwable -> {
            log.warn("\u5904\u7406\u672a\u5bfc\u5165\u7ed3\u675f\u7684\u5931\u8d25", throwable);
            return null;
        });
    }

    private void initTempDir() {
        this.tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (this.tempDir.exists()) {
            return;
        }
        if (!this.tempDir.mkdirs()) {
            throw new IllegalArgumentException("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + this.tempDir.getAbsolutePath());
        }
    }

    public HttpEntity<StreamingResponseBody> downloadByCode(@NotBlank String code) {
        return this.fsmTmplSupport.downloadByCode(code);
    }

    public com.elitescloud.cloudt.common.base.ApiResult<ImportResultRespVO> importData(@NotBlank String code, @NotNull MultipartFile dataFile) {
        SysTmplDTO tmplDTO = this.fsmTmplSupport.getTmplByCode(code);
        String msg = this.validateBeforeDeal(tmplDTO);
        if (msg != null) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)msg);
        }
        Long recordId = null;
        try {
            recordId = this.saveRecord(tmplDTO, dataFile, null);
        }
        catch (Exception exception) {
            this.afterImport(tmplDTO, null, null, ExceptionUtil.getRootCause((Throwable)exception).getMessage());
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)("\u5bfc\u5165\u5931\u8d25\uff0c" + exception.getMessage()));
        }
        DataImportServiceFactory.ServiceMetaData dataImportService = this.dataImportServiceFactory.getDataImportService(code);
        ImportResultRespVO respVO = null;
        try {
            respVO = this.startImport(recordId, tmplDTO, dataFile, dataImportService);
        }
        catch (Exception exception) {
            log.error("\u5bfc\u5165\u5931\u8d25", (Throwable)exception);
            this.afterImport(tmplDTO, recordId, 0L, ExceptionUtil.getRootCause((Throwable)exception).getMessage());
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)("\u5bfc\u5165\u5931\u8d25" + (String)(exception instanceof BusinessException ? "\uff0c" + exception.getMessage() : "")));
        }
        if (Boolean.TRUE.equals(respVO.getSync())) {
            this.afterImport(tmplDTO, recordId, (long)((Integer)ObjectUtil.defaultIfNull((Object)respVO.getSyncResult().getNumSuccess(), (Object)0)), CharSequenceUtil.join((CharSequence)"\uff1b", respVO.getSyncResult().getFailRecords()));
        }
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)respVO);
    }

    public com.elitescloud.cloudt.common.base.ApiResult<ExportResultRespVO> exportData(@NotBlank String code, Map<String, Object> queryParam) {
        AnalyseResult result;
        SysTmplDTO tmplDTO = this.fsmTmplSupport.getTmplByCode(code);
        String msg = this.validateBeforeDeal(tmplDTO);
        if (msg != null) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)msg);
        }
        Long recordId = null;
        try {
            recordId = this.saveRecord(tmplDTO, null, queryParam);
        }
        catch (Exception exception) {
            this.afterImport(tmplDTO, null, null, ExceptionUtil.getRootCause((Throwable)exception).getMessage());
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6587\u4ef6\u670d\u52a1\u5668\u5f02\u5e38");
        }
        DataExportServiceFactory.ServiceMetaData dataExportService = this.dataExportServiceFactory.getDataExportService(code);
        try {
            result = this.startExport(recordId, tmplDTO, queryParam, dataExportService);
        }
        catch (Exception exception) {
            log.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)exception);
            this.afterImport(tmplDTO, recordId, 0L, ExceptionUtil.getRootCause((Throwable)exception).getMessage());
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)("\u5bfc\u51fa\u5931\u8d25" + (String)(exception instanceof BusinessException ? "\uff0c" + exception.getMessage() : "")));
        }
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)new ExportResultRespVO(result.getSync(), recordId, result.getTotal()));
    }

    public HttpEntity<StreamingResponseBody> downloadExportFile(Long id) {
        AtomicInteger times = new AtomicInteger(1);
        String code = TmplDataService.retry(() -> this.fsmTmplSupport.getRecordFileCode(id), c -> {
            if (CharSequenceUtil.isNotBlank((CharSequence)c)) {
                return true;
            }
            return times.getAndAdd(1) >= 5;
        }, Duration.ofMinutes(1L));
        if (CharSequenceUtil.isBlank((CharSequence)code)) {
            log.error("\u4e0b\u8f7d\u5bfc\u51fa\u8bb0\u5f55{}\u7684\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728", (Object)id);
            return ResponseEntity.badRequest().build();
        }
        return this.fileService.download(code, null);
    }

    public com.elitescloud.cloudt.common.base.ApiResult<ImportRateRespVO> getRate(Long id) {
        SysImportRateDTO rateDTO = null;
        try {
            rateDTO = this.fsmTmplSupport.getImportRateFromCache(id);
            if (rateDTO == null || ObjectUtil.equals((Object)rateDTO.getTotal(), (Object)rateDTO.getCount())) {
                rateDTO = this.fsmTmplSupport.getImportRate(id);
            }
        }
        catch (Exception exception) {
            log.error("\u67e5\u8be2\u5bfc\u5165\u8fdb\u5ea6\u5931\u8d25", (Throwable)exception);
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u67e5\u8be2\u5bfc\u5165\u8fdb\u5ea6\u5931\u8d25");
        }
        if (rateDTO == null) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u5bfc\u5165\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        ImportRateRespVO respVO = new ImportRateRespVO();
        respVO.setFinish(rateDTO.getFinish());
        respVO.setTotal(rateDTO.getTotal());
        respVO.setCount(rateDTO.getCount());
        if (ObjectUtil.equals((Object)rateDTO.getTotal(), (Object)rateDTO.getCount())) {
            respVO.setFinish(true);
            respVO.setRate("100%");
        } else {
            long count = ((Number)ObjectUtil.defaultIfNull((Object)rateDTO.getCount(), (Object)0)).longValue();
            long total = ((Number)ObjectUtil.defaultIfNull((Object)rateDTO.getTotal(), (Object)1)).longValue();
            respVO.setRate(BigDecimal.valueOf((double)count * 1.0 / (double)total * 100.0).setScale(0, RoundingMode.DOWN) + "%");
        }
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)respVO);
    }

    private Long saveRecord(SysTmplDTO tmplDTO, MultipartFile dataFile, Map<String, Object> queryParam) {
        return this.fsmTmplSupport.saveRecord(tmplDTO.getCode(), dataFile, queryParam);
    }

    private String validateBeforeDeal(SysTmplDTO tmplDTO) {
        if (tmplDTO == null || Boolean.FALSE.equals(tmplDTO.getEnabled())) {
            return "\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528";
        }
        if (CollUtil.isEmpty(tmplDTO.getAttributes())) {
            return "\u6a21\u677f\u65e0\u6548";
        }
        boolean export = Boolean.TRUE.equals(tmplDTO.getExport());
        if (export) {
            if (!this.dataExportServiceFactory.isSupport(tmplDTO.getCode())) {
                return "\u672a\u53d1\u73b0\u6709\u6548\u7684\u6570\u636e\u5bfc\u51fa\u670d\u52a1";
            }
        } else if (!this.dataImportServiceFactory.isSupport(tmplDTO.getCode())) {
            return "\u672a\u53d1\u73b0\u6709\u6548\u7684\u6570\u636e\u5bfc\u5165\u670d\u52a1";
        }
        if (!this.fsmTmplSupport.updateLimiter(tmplDTO, true)) {
            return "\u5f53\u524d\u8bbf\u95ee\u7528\u6237\u8fc7\u591a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
        }
        return null;
    }

    private void afterImport(SysTmplDTO tmplDTO, Long recordId, Long numSuc, String msg) {
        this.afterImport(tmplDTO, recordId, numSuc, msg, null);
    }

    private void afterImport(SysTmplDTO tmplDTO, Long recordId, Long numSuc, String msg, File file) {
        if (recordId != null) {
            String fileCode = this.uploadImportFile(file);
            RecordResultSaveDTO importResultDTO = RecordResultSaveDTO.builder().recordId(recordId).success(CharSequenceUtil.isBlank((CharSequence)msg)).numSuc(numSuc).failMsg(msg).fileCode(fileCode).build();
            this.fsmTmplSupport.updateImportResult(importResultDTO);
        } else {
            log.error("\u66f4\u65b0\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55\u7ed3\u679c\u5931\u8d25\uff1a{}", (Object)msg);
        }
        this.fsmTmplSupport.updateLimiter(tmplDTO, false);
    }

    private String uploadImportFile(File file) {
        if (file != null) {
            ApiResult uploadResult = this.fileService.upload(file);
            file.delete();
            if (uploadResult.isSuccess() && uploadResult.getData() != null) {
                return ((FileObjRespVO)uploadResult.getData()).getFileCode();
            }
            log.error("\u4e0a\u4f20\u5bfc\u5165\u5bfc\u51fa\u7ed3\u679c\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)uploadResult);
        }
        return null;
    }

    private List<?> analyseData(SysTmplDTO tmplDTO, MultipartFile dataFile, DataImportServiceFactory.ServiceMetaData dataImportService) {
        try {
            return ExcelImportUtil.instance(dataFile.getInputStream()).headRow(tmplDTO.getHeadRow()).dataType(dataImportService.getDataType(), tmplDTO.getAttributes().get(tmplDTO.getFieldTypeRow() - 1)).readAllSync();
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u5bfc\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u89e3\u6790\u5bfc\u5165\u6570\u636e\u5931\u8d25");
        }
    }

    private AnalyseResult startExport(Long recordId, SysTmplDTO tmplDTO, Map<String, Object> queryParam, DataExportServiceFactory.ServiceMetaData dataExportService) {
        boolean sync;
        DataExport<Serializable, AbstractOrderQueryParam> exportService = dataExportService.getDataExport();
        AbstractOrderQueryParam param = this.convertParam(queryParam, dataExportService.getParamType());
        int pageSize = this.obtainPageSize(dataExportService.getDataExport());
        param.setCurrent(Integer.valueOf(1));
        param.setSize(Integer.valueOf(pageSize));
        PagingVO<Serializable> queryResult = exportService.execute(param, 1, pageSize);
        if (queryResult == null || queryResult.getTotal() == 0L) {
            throw new BusinessException("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
        }
        int limit = (Integer)ObjectUtil.defaultIfNull((Object)tmplDTO.getDataLimitPer(), (Object)-1);
        if (limit != -1 && queryResult.getTotal() > (long)limit) {
            throw new BusinessException("\u6bcf\u6b21\u6700\u591a\u5141\u8bb8\u5bfc\u51fa" + limit + "\u6761");
        }
        CompletableFuture.runAsync(() -> this.fsmTmplSupport.updateImportNum(recordId, queryResult.getTotal()), (Executor)this.taskExecutor);
        boolean bl = sync = tmplDTO.getAsyncThreshold() == null || tmplDTO.getAsyncThreshold() == -1 || queryResult.getTotal() <= (long)tmplDTO.getAsyncThreshold().intValue();
        if (sync) {
            this.exportSync(recordId, tmplDTO, queryResult, param, exportService);
            return new AnalyseResult(queryResult.getTotal(), true);
        }
        this.exportAsync(recordId, tmplDTO, queryResult, param, exportService);
        return new AnalyseResult(queryResult.getTotal(), false);
    }

    private void exportAsync(Long recordId, SysTmplDTO tmplDTO, PagingVO<Serializable> pageData, AbstractOrderQueryParam queryParam, DataExport<Serializable, AbstractOrderQueryParam> dataExport) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        CompletableFuture.supplyAsync(() -> {
            if (authentication != null) {
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
            return this.write2Excel(false, recordId, tmplDTO, pageData, queryParam, dataExport);
        }, (Executor)this.taskExecutor).whenComplete((ret, throwable) -> {
            this.fsmTmplSupport.removeRate(recordId);
            if (throwable == null) {
                this.afterImport(tmplDTO, recordId, (Long)ret, null);
            } else {
                this.afterImport(tmplDTO, recordId, 0L, ExceptionUtil.getRootCause((Throwable)throwable).getMessage());
                log.error("\u5bfc\u51fa\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a", throwable);
            }
        });
    }

    private int obtainPageSize(DataExport<Serializable, AbstractOrderQueryParam> dataExportService) {
        Integer pageSize = dataExportService.pageSize();
        if (pageSize == null || pageSize < 1 || pageSize > 1000) {
            return 500;
        }
        return pageSize;
    }

    private int obtainStepSize(DataImport<Serializable> dataImport) {
        Integer stepSize = dataImport.stepSize();
        if (stepSize == null || stepSize < 1 || stepSize > 1000) {
            return 10;
        }
        return stepSize;
    }

    private void exportSync(Long recordId, SysTmplDTO tmplDTO, PagingVO<Serializable> pageData, AbstractOrderQueryParam queryParam, DataExport<Serializable, AbstractOrderQueryParam> dataExport) {
        Long num = this.write2Excel(true, recordId, tmplDTO, pageData, queryParam, dataExport);
        this.afterImport(tmplDTO, recordId, num, null);
    }

    private Long write2Excel(boolean sync, Long recordId, SysTmplDTO tmplDTO, PagingVO<Serializable> pageData, AbstractOrderQueryParam queryParam, DataExport<Serializable, AbstractOrderQueryParam> dataExport) {
        ExportStrategyParam param = new ExportStrategyParam().setSync(sync).setImportId(recordId).setTmplDTO(tmplDTO).setFirstPageData(pageData).setQueryParam(queryParam).setDataExport(dataExport);
        return this.exportStrategyDelegate.export(param);
    }

    private <E extends Serializable> E convertParam(Map<String, Object> queryParam, Class<E> paramType) {
        try {
            return (E)((Serializable)this.objectMapper.convertValue(queryParam, paramType));
        }
        catch (IllegalArgumentException e) {
            throw new BusinessException("\u8f6c\u6362\u67e5\u8be2\u53c2\u6570\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u683c\u5f0f", (Throwable)e);
        }
    }

    private ImportResultRespVO startImport(Long recordId, SysTmplDTO tmplDTO, MultipartFile dataFile, DataImportServiceFactory.ServiceMetaData dataImportService) {
        boolean sync;
        List<?> dataList = this.analyseData(tmplDTO, dataFile, dataImportService);
        int total = dataList.size();
        if (total == 0) {
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (tmplDTO.getDataLimitPer() != -1 && total > tmplDTO.getDataLimitPer()) {
            throw new BusinessException("\u6bcf\u6b21\u6700\u591a\u5141\u8bb8\u5bfc\u5165" + tmplDTO.getDataLimitPer() + "\u6761");
        }
        this.fsmTmplSupport.updateImportNum(recordId, Long.valueOf(total));
        boolean bl = sync = tmplDTO.getAsyncThreshold() == null || tmplDTO.getAsyncThreshold() == -1 || total <= tmplDTO.getAsyncThreshold();
        if (sync) {
            ImportResultRespVO.SyncResult syncResult = dataImportService.getDataImport().execute(dataList, tmplDTO.getHeadRow() + 1);
            return ImportResultRespVO.builder().sync(true).syncResult(syncResult).build();
        }
        CompletableFuture.supplyAsync(() -> this.importAsync(tmplDTO, recordId, dataImportService.getDataImport(), dataList), (Executor)this.taskExecutor).whenComplete((ret, throwable) -> {
            this.fsmTmplSupport.removeRate(recordId);
            if (throwable == null) {
                this.afterImport(tmplDTO, recordId, (long)ret.getNumSuccess(), CharSequenceUtil.join((CharSequence)"\uff1b", ret.getFailRecords()));
            } else {
                String failMsg = ret != null && ret.getFailRecords() != null ? CharSequenceUtil.join((CharSequence)"\uff1b", ret.getFailRecords()) : "";
                this.afterImport(tmplDTO, recordId, 0L, failMsg + "\uff1b" + ExceptionUtil.getRootCause((Throwable)throwable).getMessage());
                log.error("\u5bfc\u5165\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a", throwable);
            }
        });
        return ImportResultRespVO.builder().sync(false).asyncResult(ImportResultRespVO.AsyncResult.builder().importId(recordId).build()).build();
    }

    private ImportResultRespVO.SyncResult importAsync(SysTmplDTO tmplDTO, Long recordId, DataImport<Serializable> dataImportService, List<Serializable> dataList) {
        int total = dataList.size();
        int size = this.obtainStepSize(dataImportService);
        int start = 0;
        int numSuc = 0;
        ImportResultRespVO.SyncResult tempResult = null;
        ArrayList<String> fail = new ArrayList<String>(1024);
        int i = 0;
        while (true) {
            start = i * size;
            try {
                tempResult = dataImportService.execute(dataList.subList(start, Math.min(start + size, total)), tmplDTO.getHeadRow() + 1 + start);
            }
            catch (Exception exception) {
                log.error("\u5bfc\u5165\u5931\u8d25", (Throwable)exception);
                fail.add(String.format("total\uff1a%s\uff0cstart:%s\uff0cexception:%s", total, start, exception.getMessage()));
            }
            if (tempResult != null) {
                numSuc += ((Integer)ObjectUtil.defaultIfNull((Object)tempResult.getNumSuccess(), (Object)0)).intValue();
                if (CollUtil.isNotEmpty(tempResult.getFailRecords())) {
                    fail.addAll(tempResult.getFailRecords());
                }
            }
            boolean finish = start + size >= total;
            this.fsmTmplSupport.storeRate(recordId, SysImportRateDTO.builder().finish(finish).total(Long.valueOf(total)).count(Long.valueOf(numSuc)).tmplCode(dataImportService.getTmplCode()).build());
            if (finish) break;
            ++i;
        }
        return ImportResultRespVO.SyncResult.builder().total(total).numSuccess(numSuc).failRecords(fail).build();
    }

    private static <T> T retry(Supplier<T> supplier, Predicate<T> predicate, Duration timeout) {
        long limit = timeout.toMillis();
        long start = System.currentTimeMillis();
        int times = 1;
        T result = null;
        while (!predicate.test(result = (T)supplier.get()) && System.currentTimeMillis() - start <= limit) {
            try {
                TimeUnit.SECONDS.sleep(times);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++times;
        }
        return result;
    }

    static class AnalyseResult {
        private Long total;
        private Boolean sync;

        public AnalyseResult(Long total, Boolean sync) {
            this.total = total;
            this.sync = sync;
        }

        public Long getTotal() {
            return this.total;
        }

        public Boolean getSync() {
            return this.sync;
        }

        public void setTotal(Long total) {
            this.total = total;
        }

        public void setSync(Boolean sync) {
            this.sync = sync;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AnalyseResult)) {
                return false;
            }
            AnalyseResult other = (AnalyseResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$total = this.getTotal();
            Long other$total = other.getTotal();
            if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
                return false;
            }
            Boolean this$sync = this.getSync();
            Boolean other$sync = other.getSync();
            return !(this$sync == null ? other$sync != null : !((Object)this$sync).equals(other$sync));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AnalyseResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $total = this.getTotal();
            result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
            Boolean $sync = this.getSync();
            result = result * 59 + ($sync == null ? 43 : ((Object)$sync).hashCode());
            return result;
        }

        public String toString() {
            return "TmplDataService.AnalyseResult(total=" + this.getTotal() + ", sync=" + this.getSync() + ")";
        }
    }
}

