package com.elitescloud.boot.excel.config.tmpl;

import com.alibaba.excel.EasyExcel;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.excel.common.support.TmplApiService;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.boot.excel.config.tmpl.export.strategy.TmplExportStrategyDelegate;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

import java.util.stream.Collectors;

/**
 * 根据模板文件导入导出配置.
 *
 * @author Kaiser（wang shao）
 * @date 2/17/2023
 */
@ConditionalOnClass({EasyExcel.class, FileService.class})
public class TmplConfig {

    private final TmplApiService tmplApiService;
    private final RedisUtils redisUtils;
    private final FileService<?> fileService;

    public TmplConfig(TmplApiService tmplApiService, RedisUtils redisUtils, FileService<?> fileService) {
        this.tmplApiService = tmplApiService;
        this.redisUtils = redisUtils;
        this.fileService = fileService;
    }

    @Bean
    SystemTmplDataSupport systemTmplDataSupport() {
        return new SystemTmplDataSupport(tmplApiService, redisUtils, fileService);
    }

    @Bean
    DataImportServiceFactory systemDataImportServiceFactory(ObjectProvider<DataImport<?>> dataImportProvider) {
        var dataImportList = dataImportProvider.stream().collect(Collectors.toList());
        return new DataImportServiceFactory(dataImportList);
    }

    @Bean
    DataExportServiceFactory systemDataExportServiceFactory(ObjectProvider<DataExport<?, ?>> dataExportProvider) {
        var dataExportList = dataExportProvider.stream().collect(Collectors.toList());
        return new DataExportServiceFactory(dataExportList);
    }

    @Bean
    TmplDataService tmplDataService(SystemTmplDataSupport systemTmplDataSupport) {
        return new TmplDataService(fileService, systemTmplDataSupport);
    }

    @Bean
    TmplDataController tmplDataController(TmplDataService tmplDataService) {
        return new TmplDataController(tmplDataService);
    }

    @Bean
    TmplExportStrategyDelegate tmplExportStrategyDelegate(SystemTmplDataSupport fsmTmplSupport, ObjectMapper objectMapper) {
        return new TmplExportStrategyDelegate(fileService, fsmTmplSupport, objectMapper);
    }
}
