/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.elitescloud.boot.excel.common.param.ExportColumnParam;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.CollectionUtils;

public class ExcelExportUtil {
    private final Logger logger = LoggerFactory.getLogger(ExcelExportUtil.class);
    public static final String PROPERTY_EXPORT_LIMIT = "_YST_CORE_EXPORT_LIMIT";
    private final ExcelWriterBuilder builder;
    private List<String> fields;
    private Integer size = 50;
    private DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    protected ExcelExportUtil(OutputStream outputStream) {
        this.builder = EasyExcelFactory.write((OutputStream)outputStream).autoCloseStream(Boolean.valueOf(true));
    }

    public static ExcelExportUtil instance(OutputStream outputStream) throws IOException {
        return new ExcelExportUtil(outputStream);
    }

    public ExcelExportUtil fields(List<ExportColumnParam> columnParamList) {
        if (columnParamList != null && !columnParamList.isEmpty()) {
            ArrayList<List<String>> titles = new ArrayList<List<String>>(64);
            ArrayList<String> includeFields = new ArrayList<String>(64);
            for (ExportColumnParam p : columnParamList) {
                if (StrUtil.isBlank((CharSequence)p.getTitle()) || StrUtil.isBlank((CharSequence)p.getField())) continue;
                titles.add(List.of(p.getTitle()));
                includeFields.add(p.getField());
            }
            this.builder.head(titles);
            this.fields = includeFields;
        }
        return this;
    }

    public ExcelExportUtil batchSize(Integer size) {
        if (size == null || size < 1) {
            throw new IllegalArgumentException("size\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        this.size = size;
        return this;
    }

    public ExcelExportUtil dateFormat(String dateFormat) {
        this.dateFormatter = DateTimeFormatter.ofPattern(dateFormat);
        return this;
    }

    public void write(String sheetName, List<?> data) {
        long start = System.currentTimeMillis();
        Assert.notEmpty(this.fields, (String)"\u672a\u77e5\u5bfc\u51fa\u7684\u6570\u636e\u5217", (Object[])new Object[0]);
        List<List<String>> dataConvert = this.convertAllData(data);
        this.builder.sheet(sheetName).doWrite(dataConvert);
        this.logger.info("excel\u5bfc\u51fa\u5b8c\u6bd5\uff0c\u7528\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String sheetName, BiFunction<Integer, Integer, List<?>> dataProducer) {
        long start = System.currentTimeMillis();
        Assert.notEmpty(this.fields, (String)"\u672a\u77e5\u5bfc\u51fa\u7684\u6570\u636e\u5217", (Object[])new Object[0]);
        ExcelWriter excelWriter = this.builder.build();
        try {
            this.writeDataByPage(excelWriter, sheetName, dataProducer);
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            excelWriter.finish();
        }
        this.logger.info("excel\u5bfc\u51fa\u5b8c\u6bd5\uff0c\u7528\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
    }

    private void writeDataByPage(ExcelWriter excelWriter, String sheetName, BiFunction<Integer, Integer, List<?>> dataProducer) {
        Integer limit = this.getLimitNumOfExport();
        this.logger.info("\u5bfc\u51fa\u6570\u91cf\u9650\u5236\uff1a{}", (Object)limit);
        if (limit != null && limit < 1) {
            this.builder.sheet(sheetName).doWrite(Collections.emptyList());
            return;
        }
        ExcelWriterSheetBuilder writerSheetBuilder = new ExcelWriterSheetBuilder(excelWriter);
        writerSheetBuilder.sheetName(sheetName);
        WriteSheet writeSheet = writerSheetBuilder.build();
        int rows = 0;
        int page = 1;
        List dataList = null;
        ObjectMapper objectMapper = this.getObjectMapper();
        do {
            if (CollectionUtils.isEmpty(dataList = dataProducer.apply(page++, this.size))) {
                if (page != 2) break;
                excelWriter.write(Collections.emptyList(), writeSheet);
                break;
            }
            if (limit != null && (rows += dataList.size()) > limit) {
                dataList = CollectionUtil.sub(dataList, (int)0, (int)(limit - rows + this.size));
            }
            List convertData = ((List)objectMapper.convertValue(dataList, (TypeReference)new TypeReference<List<Map<String, Object>>>(){})).stream().map(data -> this.fields.stream().map(field -> this.obtainValue((Map<String, Object>)data, (String)field)).collect(Collectors.toList())).collect(Collectors.toList());
            excelWriter.write(convertData, writeSheet);
        } while (dataList.size() >= this.size);
    }

    private List<List<String>> convertAllData(List<?> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.emptyList();
        }
        Integer limit = this.getLimitNumOfExport();
        this.logger.info("\u5bfc\u51fa\u6570\u91cf\u9650\u5236\uff1a{}", (Object)limit);
        if (limit != null) {
            if (limit < 1) {
                return Collections.emptyList();
            }
            dataList = CollectionUtil.sub(dataList, (int)0, (int)limit);
        }
        return this.convertData(dataList);
    }

    private List<List<String>> convertData(List<?> dataList) {
        return ((List)this.getObjectMapper().convertValue(dataList, (TypeReference)new TypeReference<List<Map<String, Object>>>(){})).stream().map(data -> this.fields.stream().map(field -> this.obtainValue((Map<String, Object>)data, (String)field)).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private Integer getLimitNumOfExport() {
        String limit = System.getProperty(PROPERTY_EXPORT_LIMIT, "1000000");
        return limit.equals("-1") ? null : Integer.valueOf(limit);
    }

    private String obtainValue(Map<String, Object> data, String field) {
        Object value = data.get(field);
        if (value == null) {
            return "";
        }
        if (value instanceof LocalDateTime) {
            return this.dateFormatter.format((LocalDateTime)value);
        }
        if (value instanceof Double) {
            return NumberUtil.decimalFormatMoney((double)((Double)value));
        }
        if (value instanceof Float) {
            return NumberUtil.decimalFormatMoney((double)((Float)value).floatValue());
        }
        return value.toString();
    }

    private ObjectMapper getObjectMapper() {
        return new Jackson2ObjectMapperBuilder().serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(this.dateFormatter)).deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(this.dateFormatter)).build();
    }
}

