/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.util;

import cn.hutool.poi.excel.RowUtil;
import cn.hutool.poi.excel.cell.CellUtil;
import cn.hutool.poi.excel.style.StyleUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public final class ExcelUtil
extends cn.hutool.poi.excel.ExcelUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ExcelUtil.class);

    private ExcelUtil() {
    }

    public static void copyRows(@NonNull Sheet source, @NonNull Sheet target, int startIndex, int endIndex) {
        Assert.isTrue((endIndex > startIndex ? 1 : 0) != 0, (String)"endIndex\u5fc5\u987b\u5927\u4e8estartIndex");
        int startRowNum = source.getFirstRowNum();
        int endRowNum = source.getLastRowNum();
        if (startIndex > endRowNum || endIndex < startRowNum) {
            LOG.warn("\u6ca1\u6709\u53ef\u590d\u5236\u7684\u884c\u6570\uff1a{}-{}, {}-{}", new Object[]{startIndex, endIndex, startRowNum, endRowNum});
            return;
        }
        for (int i = startIndex; i <= endIndex; ++i) {
            int colNum;
            Row sourceRow = source.getRow(i);
            int n = colNum = sourceRow == null ? -1 : (int)sourceRow.getLastCellNum();
            if (colNum < 1) continue;
            Row targetRow = RowUtil.getOrCreateRow((Sheet)target, (int)i);
            for (int j = sourceRow.getFirstCellNum(); j < colNum; ++j) {
                Cell sourceCell = sourceRow.getCell(j);
                if (sourceCell == null) continue;
                Cell targetCell = CellUtil.getOrCreateCell((Row)targetRow, (int)j);
                targetCell.setCellValue(sourceCell.getStringCellValue());
                targetCell.setCellStyle(StyleUtil.cloneCellStyle((Cell)targetCell, (CellStyle)sourceCell.getCellStyle()));
            }
        }
    }
}

