package com.elitescloud.boot.excel.common.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 导出列.
 *
 * @author Kaiser（wang shao）
 * @date 2020-12-31
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "导出列，为空时由后端提供")
public class ExportColumnParam implements Serializable {
    private static final long serialVersionUID = 1534102554376145313L;

    /**
     * 列编号
     */
    @ApiModelProperty("字段名称")
    private String field;
    /**
     * 列名称
     */
    @ApiModelProperty("列名称")
    private String title;
}
