package com.elitescloud.boot.excel.common.param;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 导出查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("可排序查询导出数据参数对象")
public class AbstractExportQueryParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 5869225669096463692L;

    /**
     * 需要导出的列
     */
    @ApiModelProperty(value = "导出列", example = "", position = 1)
    private List<com.elitescloud.cloudt.common.base.param.ExportColumnParam> exportColumn;

    /**
     * 需要导出里的明细记录列
     */
    @ApiModelProperty(value = "导出列的明细记录列", example = "", position = 2)
    private List<com.elitescloud.cloudt.common.base.param.ExportColumnParam> exportDetailColumn;

    /**
     * 导出文件的名称
     */
    @ApiModelProperty(value = "导出文件的名称", example = "订单列表.xlsx", position = 3)
    private String fileName;
}
