package com.elitescloud.boot.excel.config.tmpl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.elitescloud.boot.exception.BusinessException;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 数据导出服务工厂.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/4
 */
@Slf4j
class DataExportServiceFactory {

    private final Map<String, ServiceMetaData> dataExportMap = new HashMap<>(64);

    public DataExportServiceFactory(List<DataExport<?, ?>> dataExportList) {
        init(dataExportList);
    }

    /**
     * 判断是否有支持的导出服务
     *
     * @param tmplCode 模板编号
     * @return 是否有支持
     */
    public boolean isSupport(String tmplCode) {
        return dataExportMap.containsKey(tmplCode);
    }

    /**
     * 获取导出服务
     *
     * @param tmplCode 模板编号
     * @return 数据导入服务
     */
    public ServiceMetaData getDataExportService(String tmplCode) {
        return dataExportMap.get(tmplCode);
    }

    private void init(List<DataExport<?, ?>> dataExportList) {
        if (CollUtil.isEmpty(dataExportList)) {
            return;
        }
        for (var DataExport : dataExportList) {
            if (dataExportMap.containsKey(DataExport.getTmplCode())) {
                throw new BusinessException("存在重复的数据导出服务：" + DataExport.getTmplCode());
            }
            dataExportMap.put(DataExport.getTmplCode(), new ServiceMetaData(DataExport));
        }
    }

    @Data
    public static class ServiceMetaData {
        private final DataExport<Serializable, AbstractOrderQueryParam> dataExport;
        private final Class<? extends Serializable> dataType;
        private final Class<? extends AbstractOrderQueryParam> paramType;

        public ServiceMetaData(DataExport<?, ?> dataExport) {
            this.dataExport = (DataExport<Serializable, AbstractOrderQueryParam>) dataExport;

            var arguments = ((ParameterizedType) dataExport.getClass().getGenericInterfaces()[0]).getActualTypeArguments();
            this.dataType = (Class<? extends Serializable>) arguments[0];
            this.paramType = (Class<? extends AbstractOrderQueryParam>) arguments[1];
        }
    }
}
