package com.elitescloud.boot.excel.common;


import com.elitescloud.cloudt.system.dto.resp.ImportResultRespVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * 数据导入接口.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/3
 */
public interface DataImport<T> {
    Logger LOG = LoggerFactory.getLogger(DataImport.class);

    /**
     * 获取模板编号
     *
     * @return 模板编号
     */
    String getTmplCode();

    /**
     * 导入数据
     *
     * @param dataList      数据列表
     * @param startRowIndex 开始行索引
     * @return 导入结果
     * @deprecated 已遗弃，请使用 {@link #executeImport(List, int)}
     */
    @Deprecated(forRemoval = true, since = "3.3.0")
    default ImportResultRespVO.SyncResult execute(List<T> dataList, int startRowIndex) {
        return ImportResultRespVO.SyncResult.builder().failRecords(Collections.emptyList()).build();
    }

    /**
     * 导入数据
     * <p>
     * 分批导入解析到的数据dataList，startRowIndex是dataList中第一条数据在excel文件中的行号，业务处理完毕后需要将每条数据的导入结果放到List中返回，
     * 为空的表示对应的数据导入成功，否则表示失败原因，如
     * <pre><code>
     *     List<String> fail = new ArrayList<>();
     *     for (UserInfo userInfo: dataList) {
     *           fail.add(userService.importUser(userInfo).getMsg());
     *     }
     *     return fail;
     * </code></pre>
     *
     * @param dataList      数据列表
     * @param startRowIndex 开始行索引
     * @return 导入结果，为空则表示全部成功
     */
    default List<String> executeImport(List<T> dataList, int startRowIndex) {
        LOG.warn("导入数据未实现！");
        return null;
    }

    /**
     * 每次取的数据量
     *
     * @return 数据条数
     */
    default Integer stepSize() {
        return 20;
    }

    /**
     * 要读取的sheet页
     * <p>
     * 为空则读取所有
     *
     * @return sheet页列表
     */
    default Set<Integer> sheetNoList() {
        return null;
    }
}
