package com.elitescloud.cloudt.system.dto.req;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * 模板导入导出结果.
 *
 * @author Kaiser（wang shao）
 * @date 3/20/2023
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RecordResultSaveDTO implements Serializable {
    private static final long serialVersionUID = -648296575449078254L;

    /**
     * 记录ID
     */
    @NotNull(message = "记录ID为空")
    private Long recordId;

    /**
     * 是否导入成功
     */
    private Boolean success;

    /**
     * 导入失败信息
     */
    private String failMsg;

    /**
     * 导入成功数量
     */
    private Long numSuc;

    /**
     * 文件编码
     */
    private String fileCode;
}
