package com.elitescloud.boot.excel.common.param;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 导入记录.
 *
 * @author Kaiser（wang shao）
 * @date 2023/5/8
 */
@Data
@ApiModel(description = "导入导出记录")
public class ImportRecordRespVO implements Serializable {
    private static final long serialVersionUID = -8741272092934155669L;

    /**
     * 记录ID
     */
    @ApiModelProperty(value = "记录ID", position = 1)
    private Long id;

    /**
     * 操作用户名称
     */
    @ApiModelProperty(value = "操作用户名称", position = 2)
    private String userName;

    /**
     * 导入文件信息
     */
    @ApiModelProperty(value = "导入文件信息", position = 3)
    private FileObjRespVO<?> fileInfo;

    /**
     * 开始时间
     */
    @ApiModelProperty(value = "导入时间", position = 4)
    private LocalDateTime timeImport;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "导入结束时间", position = 5)
    private LocalDateTime timeFinish;

    /**
     * 是否结束
     */
    @ApiModelProperty(value = "是否已结束", position = 6)
    private Boolean finish;

    /**
     * 总数
     */
    @ApiModelProperty(value = "导入总数", position = 7)
    private Long numTotal;

    /**
     * 成功数量
     */
    @ApiModelProperty(value = "导入成功数量", position = 8)
    private Long numSuc;

    /**
     * 失败记录的文件信息
     */
    @ApiModelProperty(value = "失败记录的文件信息", position = 9)
    private FileObjRespVO<?> failFileInfo;

    /**
     * 失败原因
     */
    @ApiModelProperty(value = "失败原因", position = 10)
    private String failReason;
}
