/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.excel.util;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.elitescloud.boot.excel.common.param.ImportDataModel;
import com.elitescloud.boot.excel.support.DataReadListener;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class ExcelImportUtil {
    private final ExcelReaderBuilder excelReaderBuilder;
    private DataReadListener readListener;

    protected ExcelImportUtil(InputStream inputStream) {
        this.excelReaderBuilder = ((ExcelReaderBuilder)EasyExcelFactory.read((InputStream)inputStream).autoCloseStream(Boolean.valueOf(true)).autoTrim(Boolean.valueOf(true))).ignoreEmptyRow(Boolean.valueOf(true));
    }

    public static ExcelImportUtil instance(InputStream inputStream) {
        return new ExcelImportUtil(inputStream);
    }

    public ExcelImportUtil headRow(Integer headRow) {
        this.excelReaderBuilder.headRowNumber(headRow);
        return this;
    }

    public ExcelImportUtil dataType(Class<?> dataType, List<String> dataTypeAttr) {
        this.readListener = new DataReadListener(dataTypeAttr);
        this.readListener.setDataType(dataType);
        return this;
    }

    public ExcelImportUtil dataType(Class<?> dataType, Integer dataTypeAttr) {
        this.readListener = new DataReadListener(dataTypeAttr);
        this.readListener.setDataType(dataType);
        return this;
    }

    public List<?> readAllSync() throws Exception {
        if (this.readListener == null) {
            return this.excelReaderBuilder.doReadAllSync();
        }
        this.excelReaderBuilder.registerReadListener((ReadListener)this.readListener);
        CompletableFuture<Boolean> completableFuture = CompletableFuture.supplyAsync(() -> {
            this.excelReaderBuilder.doReadAll();
            return this.readListener.isFinish();
        });
        if (Boolean.TRUE.equals(completableFuture.get())) {
            return this.readListener.getDataList();
        }
        return Collections.emptyList();
    }

    public void readAllAsync(Consumer<ImportDataModel> dataConsumer) throws Exception {
        this.readAllAsync(dataConsumer, null);
    }

    public void readAllAsync(Consumer<ImportDataModel> dataConsumer, Integer batchSize) throws Exception {
        if (this.readListener == null) {
            this.readListener = new DataReadListener();
        }
        this.readListener.setDataSize(batchSize);
        this.readListener.setDataConsumer(dataConsumer);
        this.excelReaderBuilder.registerReadListener((ReadListener)this.readListener);
        this.excelReaderBuilder.doReadAll();
    }
}

