package com.elitescloud.boot.excel.config.tmpl.export.strategy;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.excel.config.tmpl.export.ExportStrategyParam;
import com.elitescloud.boot.excel.config.tmpl.export.SystemTmplDataSupport;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/11/28
 */
 class NewFileExportStrategy extends BaseExportStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(NewFileExportStrategy.class);

    public NewFileExportStrategy(FileService<?> fileService, SystemTmplDataSupport fsmTmplSupport, ObjectMapper objectMapper) {
        super(fileService, fsmTmplSupport, objectMapper);
    }

    @Override
    public long export(ExportStrategyParam param) {
        int sheetLimit = sheetLimit(param.getTmplDTO());
        int page = 2;
        var pageSize = super.obtainPageSize(param.getDataExport());
        long count = 0;
        int rowCount = 0;
        int excelIndex = 0;

        var excelFile = createExportFile(param, excelIndex);
        StopWatch watch = new StopWatch();
        watch.start();

        var excelWriter = EasyExcel.write(excelFile).build();
        WriteSheet sheet = EasyExcel.writerSheet(0).sheetName("Sheet 1").build();
        // 头部
        var headers = obtainHeaders(param.getTmplDTO());
        excelWriter.write(headers, sheet);

        // 开始写数据
        var pageData = param.getFirstPageData();
        List<List<String>> writeDataList;
        var attributes = obtainAttributes(param.getTmplDTO());

        while (pageData.isNotEmpty()) {
            if (rowCount == sheetLimit) {
                // 上一页已满
                excelWriter.finish();
                super.updateExportFile(param, excelFile, excelIndex);
                excelFile.deleteOnExit();

                excelIndex++;
                rowCount = 0;
                excelFile = createExportFile(param, excelIndex);
                excelWriter = EasyExcel.write(excelFile).build();
                excelWriter.write(headers, sheet);
            }

            var tempDataList = pageData.getRecords();
            if (rowCount + pageData.size() > sheetLimit) {
                // 超出限制了，则将超出部分写入新的excel
                int start = 0;
                int end = start + (sheetLimit - rowCount);
                tempDataList = pageData.getRecords().subList(start, end);

                // 开新的excel
                while (end < pageData.size()) {
                    writeDataList = convertExportData(tempDataList, attributes);
                    excelWriter.write(writeDataList, sheet);
                    excelWriter.finish();
                    super.updateExportFile(param, excelFile, excelIndex);
                    excelFile.deleteOnExit();

                    int newEnd = end + (sheetLimit - rowCount);
                    excelIndex++;
                    excelFile = createExportFile(param, excelIndex);
                    excelWriter = EasyExcel.write(excelFile).build();
                    excelWriter.write(headers, sheet);

                    tempDataList = pageData.getRecords().subList(end, Math.min(pageData.size(), newEnd));
                    rowCount = 0;
                    end = newEnd;
                }
            }
            rowCount += tempDataList.size();
            count += pageData.size();
            writeDataList = convertExportData(tempDataList, attributes);
            excelWriter.write(writeDataList, sheet);

            // 少于页大小，则说明没有数据了
            var isFinish = pageData.size() < pageSize || pageData.getTotal() == count;
            if (!param.isSync()) {
                // 异步时更新进度
                super.updateRate(param.getImportId(), SysImportRateDTO.builder().finish(false).total(pageData.getTotal()).count(count - 1).tmplCode(param.getTmplDTO().getCode()).build());
            }
            if (isFinish) {
                break;
            }

            param.getQueryParam().setCurrent(page);
            param.getQueryParam().setSize(pageSize);
            pageData = param.getDataExport().executeExport(param.getQueryParam());
            page++;
        }
        excelWriter.finish();
        super.updateExportFile(param, excelFile, excelIndex);
        excelFile.deleteOnExit();
        watch.stop();

        // 更新导出结果
        updateExportFinish(param, count, "导出成功", excelFile);
        LOG.info(param.getImportId() + "导出结束耗时：" + watch.getTotalTimeMillis());

        return count;
    }
}
