package com.elitescloud.boot.excel.config;

import com.alibaba.excel.EasyExcel;
import com.elitescloud.boot.excel.support.ExportExcelServiceImpl;
import com.elitescloud.cloudt.core.service.ExportExcelService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;

/**
 * excel相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/18
 */
@EnableConfigurationProperties(ExcelProperties.class)
@Import({ExcelSwaggerConfig.class})
@ConditionalOnClass(EasyExcel.class)
public class ExcelConfig {

    @Bean
    @ConditionalOnProperty(prefix = "elitesland.excel.export", name = "enable", havingValue = "true", matchIfMissing = true)
    public ExportExcelService exportExcelService(ExcelProperties exportExcelProperties,
                                                 TaskExecutor taskExecutor) {
        return new ExportExcelServiceImpl(exportExcelProperties.getExport(), taskExecutor);
    }
}
