package com.elitescloud.cloudt.system.dto.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 导入（或导出）进度.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/2
 */
@Data
@ApiModel(description = "导入（或导出）进度")
public class ImportRateRespVO implements Serializable {
    private static final long serialVersionUID = -6447608047256329586L;

    /**
     * 是否处理完毕
     */
    @ApiModelProperty(value = "是否处理完毕", position = 1)
    private Boolean finish;

    /**
     * 记录总数
     */
    @ApiModelProperty(value = "记录总数", position = 2)
    private Long total;

    /**
     * 已处理数量
     */
    @ApiModelProperty(value = "已处理数量", position = 3)
    private Long count;

    /**
     * 总进度（百分比形式）
     */
    @ApiModelProperty(value = "总进度（百分比形式）", position = 4)
    private String rate;

    /**
     * 导入成功的数量
     */
    @ApiModelProperty(value = "导入成功的数量", position = 5)
    private Long numSuccess;

    /**
     * 导入失败的文件编码
     */
    @ApiModelProperty(value = "导入失败的文件编码", position = 6)
    private String failFileCode;
}
